<?php    
    echo $this->element( 'internacao-menu' );
?>
<div class="row">         
  <!-- Single button -->
    <div class="btn-group">
      <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Novo Checklist <span class="caret"></span>
      </button>
      <ul class="dropdown-menu">
        <li>
            <?php
                echo $this->Html->link(
                    'Checklist Cirúrgico',
                    ['controller' => 'surgicalChecklists', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>
         <li>
            <?php
                echo $this->Html->link(
                    'Checklist Segurança',
                    ['controller' => 'DailySafetyChecklists', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>
        <li>
            <?php
                echo $this->Html->link(
                    'Checklist Cirurgia Cardíaca',
                    ['controller' => 'CardiacSurgeryChecklists', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>
        <li>
            <?php
                echo $this->Html->link(
                    'Checklist Obstétrico',
                    ['controller' => 'ObstetricSurgeryChecklists', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>
        
      </ul>
    </div>
    <br><br> 
    <div class="surgicalChecklists index col-md-8 columns content">    
        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th>
                        Tipo
                    </th>
                    <th>                        
                        <?= $this->Paginator->sort('created', ['label'=>'Data de Preenchimento']) ?>                        
                    </th>                    
                    <th class="actions">
                        <?= __('Ações') ?>
                    </th>
                </tr>
            </thead>
            <tbody>
            
                <?php foreach ($checklists as $checklist): ?>
                    <?php foreach ($checklist['surgical_checklists'] as $surgical_checklists): ?>
                        <tr>
                            <td>
                                Checklist Cirúrgico
                            </td>
                            <td>
                                <?= h($surgical_checklists->created->format('d/m/Y')) ?>
                            </td>
                            <td class="actions" style="white-space:nowrap">
                                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $surgical_checklists->id], ['class'=>'btn btn-primary btn-xs']) ?>            
                                    <?php                     
                                        if ( h($surgical_checklists->is_active) )
                                        {
                                            echo $this->Form->postLink(__('Suspender'), ['action' => 'desactivate', $surgical_checklists->id], ['confirm' => __('Tem certeza que deseja desativar o checklist?', $surgical_checklists->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                                        }     
                                        else 
                                        {
                                           echo $this->Form->postLink(__('Ativar'), ['action' => 'activate', $surgical_checklists->id], ['confirm' => __('Tem certeza que deseja ativar o checklist?', $surgical_checklists->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                                        }                                                            
                                    ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    <?php foreach ($checklist['daily_safety_checklists'] as $daily_safety_checklists): ?>
                        <tr>
                            <td>
                                Checklist de Segurança Diário
                            </td>
                            <td>
                                <?= h($daily_safety_checklists->created->format('d/m/Y')) ?>
                            </td>
                            <td class="actions" style="white-space:nowrap">
                                    <?= $this->Html->link(__('Editar'), ['controller'=>'DailySafetyChecklists','action' => 'edit', $daily_safety_checklists->id], ['class'=>'btn btn-primary btn-xs']) ?>                                

                                    <?php                     
                                        if ( h($daily_safety_checklists->is_active) )
                                        {
                                            echo $this->Form->postLink(__('Suspender'), ['controller'=>'DailySafetyChecklists', 'action' => 'desactivate', $daily_safety_checklists->id], ['confirm' => __('Tem certeza que deseja desativar o checklist?', $daily_safety_checklists->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                                        }     
                                        else 
                                        {
                                           echo $this->Form->postLink(__('Ativar'), ['controller'=>'DailySafetyChecklists', 'action' => 'activate', $daily_safety_checklists->id], ['confirm' => __('Tem certeza que deseja ativar o checklist?', $daily_safety_checklists->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                                        }                                                            
                                    ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    <?php foreach ($checklist['cardiac_surgery_checklists'] as $cardiac_surgery_checklists): ?>
                        <tr>
                            <td>
                                Checklist Cirurgia Cardíaca
                            </td>
                            <td>
                                <?= h($cardiac_surgery_checklists->created->format('d/m/Y')) ?>
                            </td>
                            <td class="actions" style="white-space:nowrap">
                                    <?= $this->Html->link(__('Editar'), ['controller'=>'CardiacSurgeryChecklists','action' => 'edit', $cardiac_surgery_checklists->id], ['class'=>'btn btn-primary btn-xs']) ?>                                    

                                    <?php                     
                                        if ( h($cardiac_surgery_checklists->is_active) )
                                        {
                                            echo $this->Form->postLink(__('Suspender'), ['controller'=>'CardiacSurgeryChecklists', 'action' => 'desactivate', $cardiac_surgery_checklists->id], ['confirm' => __('Tem certeza que deseja desativar o checklist?', $cardiac_surgery_checklists->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                                        }     
                                        else 
                                        {
                                           echo $this->Form->postLink(__('Ativar'), ['controller'=>'CardiacSurgeryChecklists', 'action' => 'activate', $cardiac_surgery_checklists->id], ['confirm' => __('Tem certeza que deseja ativar o checklist?', $cardiac_surgery_checklists->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                                        }                                                            
                                    ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="paginator">
            <center>
                <ul class="pagination">
                    <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                        <?= $this->Paginator->numbers(['escape'=>false]) ?>
                            <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
                </ul>

        </div>
        </center>
    </div>
</div>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
    var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>', 
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

    var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link3 =' <?= $this->Html->link('Internações',['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Checklists</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>