<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * IndicatorsUnit Entity.
 *
 * @property int $id
 * @property float $taxa_de_ocupacao
 * @property float $indice_de_giro_de_leito
 * @property float $intervalo_de_substituicao
 * @property float $idade_media
 * @property float $consumo_medio
 * @property float $consumo_diario
 * @property float $consumo_diario_por_paciente
 * @property float $ticket_medio
 * @property float $ticket_diario
 * @property float $ticket_diario_por_paciente
 * @property float $ticket_por_internacao
 * @property float $glossa_total
 * @property float $glossa_por_paciente
 * @property float $faixa_de_internacao_menor_que_24h
 * @property float $faixa_de_internacao_ate_7_dias
 * @property float $faixa_de_internacao_ate_21_dias
 * @property float $faixa_de_internacao_ate_28_dias
 * @property float $faixa_de_internacao_superior_28_dias
 * @property float $taxa_de_reinternacao
 * @property float $percentual_de_altas
 * @property \Cake\I18n\Time $tempo_de_permanencia_minimo
 * @property \Cake\I18n\Time $tempo_de_permanencia_medio
 * @property \Cake\I18n\Time $tempo_de_permanencia_maximo
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 */
class IndicatorsUnit extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
