    <?php         
        $this->assign('title', $title);         
        $hasUnit = false;
    ?>

   <div class="units index col-md col-lg columns content">
    <legend>
        <h3 class="big-title">Unidades</h3>
    </legend>

    
    <br><br> 
    <div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>           
                <th><?= $this->Paginator->sort('Group', ['label'=>'Grupo']) ?></th>     
                <th><?= $this->Paginator->sort('name', ['label'=>'Unidade']) ?></th>
                <th><?= $this->Paginator->sort('Privileges', ['label'=>'Privilégio']) ?></th>
                <th><?= $this->Paginator->sort('city',['label'=>'Cidade']) ?></th>
                <th><?= $this->Paginator->sort('is_active', array('label'=>'Status')) ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if(empty($units)) : ?>
                <tr class="critical_row" style="text-align:center">
                <td colspan="6">Você não está vinculado a nenhuma unidade.</td>
                </tr>
            <?php endif; ?>
            <?php foreach ($units as $unit): ?>
               <?php $hasUnit = true; ?>
            <tr>    
                <td>
                    <?= $unit->has('group') ? $unit->group->name : ''  ?>
                </td>            
                <td><?= h($unit->name) ?></td>
                <td><?= h($unit['_matchingData']['Privileges']['name']) ?></td>
                <td><?= h($unit->city) ?></td>
                <td>
                <?php  
                    echo h($unit->is_active)? "Ativo" : "Suspenso";
                ?>
                </td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('Selecionar'), ['controller'=>'Units','action' => 'select', $unit->id], ['class'=>'btn btn-primary btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?php
                    if (  $hasUnit )
                     {
                       echo $this->Paginator->numbers(['escape'=>false]) ;
                     }
                ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            
        </div>
    </center>
</div>
</div>

