<?php
namespace App\Model\Table;

use App\Model\Entity\PavDiaryChecklist;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PavDiaryChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $PavPreventionBundles
 */
class PavDiaryChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pav_diary_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('PavPreventionBundles', [
            'foreignKey' => 'pav_prevention_bundle_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('elevacao_cabeceira')
            ->allowEmpty('elevacao_cabeceira');

        $validator
            ->boolean('avaliacao_ventilatoria_diaria')
            ->allowEmpty('avaliacao_ventilatoria_diaria');

        $validator
            ->boolean('manutencao_da_pressao_balonete')
            ->allowEmpty('manutencao_da_pressao_balonete');

        $validator
            ->boolean('higiene_bucal')
            ->allowEmpty('higiene_bucal');

        $validator
            ->boolean('inicio_da_nutricao')
            ->allowEmpty('inicio_da_nutricao');

        $validator
            ->boolean('posicao_tubo_checado')
            ->allowEmpty('posicao_tubo_checado');

        $validator
            ->boolean('pro_cinetico')
            ->allowEmpty('pro_cinetico');

        $validator
            ->boolean('presencao_de_nausea')
            ->allowEmpty('presencao_de_nausea');

        $validator
            ->boolean('gastroparesia')
            ->allowEmpty('gastroparesia');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['pav_prevention_bundle_id'], 'PavPreventionBundles'));
        return $rules;
    }
}
