<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Medication Entity.
 *
 * @property int $id
 * @property string $name
 * @property string $dosage
 * @property string $channel
 * @property string $frequency
 * @property string $start_date
 * @property string $end_date
 * @property \Cake\I18n\Time $created
 * @property bool $is_antibiotic
 * @property int $sign_id
 * @property \App\Model\Entity\Sign $sign
 * @property int $professional_id
 * @property \App\Model\Entity\Professional $professional
 * @property bool $is_active
 * @property int $prescription_id
 * @property \App\Model\Entity\Prescription $prescription
 * @property bool $cultura
 * @property string $cultura_resultado
 * @property string $justificativa_antibiotico
 * @property \App\Model\Entity\Antibiotic[] $antibiotics
 * @property \App\Model\Entity\MedicationsHistoric[] $medications_historic
 */
class Medication extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
