<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ObstetricSurgeryChecklist Entity.
 *
 * @property int $id
 * @property string $quais_equipamentos_medicamentos_adicionais_foram_necessarios
 * @property bool $algum_problema_ou_preocupacao_com_o_equipamento
 * @property string $qual_o_nivel_de_urgencia
 * @property bool $paciente_requer_type_and_screen
 * @property bool $requer_type_and_screen_o_sangue_esta_disponivel
 * @property bool $paciente_precisa_de_um_ultrassom
 * @property bool $todos_confirmaram_o_nome_e_funcao
 * @property bool $anestesia_adequada_foi_confirmada
 * @property bool $urgencia_foi_confirmada
 * @property bool $identidade_consentimento_ e_procedimento_do_paciente_confirmado
 * @property bool $paciente_esteril
 * @property bool $alguma_preocupacao_com_o_status_do_feto
 * @property bool $requerimento_confirmado_com_departamento_pediatrico
 * @property bool $thromboembolism_prophylaxis_necessario
 * @property bool $procedimento_nome_alegia_do_paciente_foram_confirmados
 * @property bool $antibiotico_prophylaxis_foi_usado
 * @property bool $especialista_do_neonatal_esta_presente
 * @property bool $especialista_neonatal_foi_notificado
 * @property bool $equipe_da_ressurreicao_esta_presente
 * @property bool $equipe_da_ressurreicao_esta_presente_e_operacional
 * @property string $qual_pontuacao_do_asa
 * @property bool $checklist_de_anestesia_foi_completado
 * @property bool $paciente_tem_todo_o_monitoramento_necessario
 * @property bool $paciente_tem_alguma_alergia
 * @property string $paciente_tem_qual_alergia
 * @property bool $paciente_apresenta_uma_aspiracao_ruim
 * @property bool $respiracao_ruim_equipamento_assistencia_esta_disponivel
 * @property bool $risco_de_hipotermia_operacao_>_1h
 * @property bool $risco_de_hipotermia_aquecedor_necessario
 * @property string $alguma_preocupacao
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 */
class ObstetricSurgeryChecklist extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
