<?php
namespace App\Model\Table;

use App\Model\Entity\ComorbiditiesDiagnostic;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ComorbiditiesDiagnostics Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Comorbidities
 * @property \Cake\ORM\Association\BelongsTo $Diagnostics
 */
class ComorbiditiesDiagnosticsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('comorbidities_diagnostics');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Comorbidities', [
            'foreignKey' => 'comorbidity_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Diagnostics', [
            'foreignKey' => 'diagnostic_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['comorbidity_id'], 'Comorbidities'));
        $rules->add($rules->existsIn(['diagnostic_id'], 'Diagnostics'));
        return $rules;
    }
}
