<?php
namespace App\Model\Table;

use App\Model\Entity\SepseProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SepseProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SepseProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sepse_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('leucocitos');

        $validator
            ->allowEmpty('sepse_protocolscol');

        $validator
            ->boolean('alteracao_estado_geral')
            ->allowEmpty('alteracao_estado_geral');

        $validator
            ->boolean('edema_generalizado')
            ->allowEmpty('edema_generalizado');

        $validator
            ->boolean('glicose_maior_que_140')
            ->allowEmpty('glicose_maior_que_140');

        $validator
            ->boolean('pcr_maior_que_2')
            ->allowEmpty('pcr_maior_que_2');

        $validator
            ->boolean('paco2_menor_que_32')
            ->allowEmpty('paco2_menor_que_32');

        $validator
            ->allowEmpty('temperatura');

        $validator
            ->allowEmpty('taquicardia');

        $validator
            ->allowEmpty('pressao');

        $validator
            ->boolean('respiratorio')
            ->allowEmpty('respiratorio');

        $validator
            ->boolean('urinario')
            ->allowEmpty('urinario');

        $validator
            ->boolean('cutaneo')
            ->allowEmpty('cutaneo');

        $validator
            ->boolean('endocardite')
            ->allowEmpty('endocardite');

        $validator
            ->boolean('articular')
            ->allowEmpty('articular');

        $validator
            ->boolean('infeccao_de_cateter')
            ->allowEmpty('infeccao_de_cateter');

        $validator
            ->boolean('sistema_nervoso_central')
            ->allowEmpty('sistema_nervoso_central');

        $validator
            ->boolean('abdominal')
            ->allowEmpty('abdominal');

        $validator
            ->allowEmpty('outros_procedimentos');

        $validator
            ->time('cultura_hora')
            ->allowEmpty('cultura_hora');

        $validator
            ->allowEmpty('lactato');

        $validator
            ->boolean('urina')
            ->allowEmpty('urina');

        $validator
            ->boolean('seq_traqueal')
            ->allowEmpty('seq_traqueal');

        $validator
            ->boolean('liquor')
            ->allowEmpty('liquor');

        $validator
            ->boolean('liquido_asotico')
            ->allowEmpty('liquido_asotico');

        $validator
            ->boolean('liq_pleural')
            ->allowEmpty('liq_pleural');

        $validator
            ->allowEmpty('abordagem_inicial_outros');

        $validator
            ->allowEmpty('atb');

        $validator
            ->time('atb_hora')
            ->allowEmpty('atb_hora');

        $validator
            ->boolean('foco_presumido_infeccao')
            ->allowEmpty('foco_presumido_infeccao');

        $validator
            ->boolean('2_criterios_de_sepse')
            ->allowEmpty('2_criterios_de_sepse');

        $validator
            ->boolean('sepse')
            ->allowEmpty('sepse');

        $validator
            ->boolean('disfuncao_organica')
            ->allowEmpty('disfuncao_organica');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
