<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Suspected Me Protocol']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Supplementary Examinations']), ['controller' => 'SupplementaryExaminations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Supplementary Examination']), ['controller' => 'SupplementaryExaminations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="suspectedMeProtocols index col-md-10 columns content">
    <h3>Suspected Me Protocols</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('causa_do_coma') ?></th>
                <th><?= $this->Paginator->sort('uso_de_drogas_depressoras') ?></th>
                <th><?= $this->Paginator->sort('hiportemia') ?></th>
                <th><?= $this->Paginator->sort('exame_data_1') ?></th>
                <th><?= $this->Paginator->sort('exame_hora_1') ?></th>
                <th><?= $this->Paginator->sort('exame_nome_medico_1') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($suspectedMeProtocols as $suspectedMeProtocol): ?>
            <tr>
                <td><?= $this->Number->format($suspectedMeProtocol->id) ?></td>
                <td><?= h($suspectedMeProtocol->causa_do_coma) ?></td>
                <td><?= h($suspectedMeProtocol->uso_de_drogas_depressoras) ?></td>
                <td><?= h($suspectedMeProtocol->hiportemia) ?></td>
                <td><?= h($suspectedMeProtocol->exame_data_1) ?></td>
                <td><?= h($suspectedMeProtocol->exame_hora_1) ?></td>
                <td><?= h($suspectedMeProtocol->exame_nome_medico_1) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $suspectedMeProtocol->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $suspectedMeProtocol->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $suspectedMeProtocol->id], ['confirm' => __('Are you sure you want to delete # {0}?', $suspectedMeProtocol->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>