<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * SepseProtocols Controller
 *
 * @property \App\Model\Table\SepseProtocolsTable $SepseProtocols
 */
class SepseProtocolsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Protocolos');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');
        $screening_id        = $this->request->session()->read('screening_id');
        $current_state       = $this->request->session()->read('current-state');
        $patient_id          = $this->request->session()->read('selected-pacient');

        // $this->paginate = [
        //     'contain' => ['Hospitalizations'],
        // ];

        $this->paginate = [
            'contain'    => ['SepseProtocols', 'ChestPainProtocols'],
            'conditions' => ['Hospitalizations.id =' => $hospitalizations_id],

        ];
        $entity_table = TableRegistry::get('Hospitalizations');
        $protocols    = $this->paginate($entity_table);
        //$sepseProtocols = $this->paginate($this->SepseProtocols);

        $this->set(compact('protocols'));
        $this->set('_serialize', ['protocols']);
    }

    /**
     * View method
     *
     * @param string|null $id Sepse Protocol id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sepseProtocol = $this->SepseProtocols->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('sepseProtocol', $sepseProtocol);
        $this->set('_serialize', ['sepseProtocol']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $sepseProtocol = $this->SepseProtocols->newEntity();
        if ($this->request->is('post')) {
            $sepseProtocol = $this->SepseProtocols->patchEntity($sepseProtocol, $this->request->data);
            if ($this->SepseProtocols->save($sepseProtocol)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo'));
            }
        }
        $hospitalizations = $this->SepseProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('sepseProtocol', 'hospitalizations'));
        $this->set('_serialize', ['sepseProtocol']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Sepse Protocol id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $sepseProtocol = $this->SepseProtocols->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $sepseProtocol = $this->SepseProtocols->patchEntity($sepseProtocol, $this->request->data);
            if ($this->SepseProtocols->save($sepseProtocol)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo'));
            }
        }
        $hospitalizations = $this->SepseProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('sepseProtocol', 'hospitalizations'));
        $this->set('_serialize', ['sepseProtocol']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Sepse Protocol id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $sepseProtocol = $this->SepseProtocols->get($id);
        if ($this->SepseProtocols->delete($sepseProtocol)) {
            $this->Flash->success(__('O registro  foi deletado'));
        } else {
            $this->Flash->error(__('O registro não foi deletado'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
