<?php
namespace App\Model\Table;

use App\Model\Entity\BarthelIndex;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * BarthelIndexes Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Barthels
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class BarthelIndexesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('barthel_indexes');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Barthels', [
            'foreignKey' => 'barthel_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('alimentacao');

        $validator
            ->allowEmpty('banho');

        $validator
            ->allowEmpty('atividades_rotineiras');

        $validator
            ->allowEmpty('vestir_se');

        $validator
            ->allowEmpty('intestino');

        $validator
            ->allowEmpty('sistema_urinario');

        $validator
            ->allowEmpty('uso_do_banheiro');

        $validator
            ->allowEmpty('transferencia');

        $validator
            ->allowEmpty('mobilidade');

        $validator
            ->allowEmpty('escadas');

        $validator
            ->allowEmpty('total_pontos');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('alimentacao_24');

        $validator
            ->allowEmpty('alimentacao_alta');

        $validator
            ->allowEmpty('banho_24');

        $validator
            ->allowEmpty('banho_alta');

        $validator
            ->allowEmpty('atividades_rotineiras_24');

        $validator
            ->allowEmpty('atividades_rotineiras_alta');

        $validator
            ->allowEmpty('vestir_se_24');

        $validator
            ->allowEmpty('vestir_se_alta');

        $validator
            ->allowEmpty('intestino_24');

        $validator
            ->allowEmpty('intestino_alta');

        $validator
            ->allowEmpty('uso_do_banheiro_24');

        $validator
            ->allowEmpty('uso_do_banheiro_alta');

        $validator
            ->allowEmpty('transferencia_24');

        $validator
            ->allowEmpty('transferencia_alta');

        $validator
            ->allowEmpty('mobilidade_24');

        $validator
            ->allowEmpty('mobilidade_alta');

        $validator
            ->allowEmpty('escadas_24');

        $validator
            ->allowEmpty('escadas_alta');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['barthel_id'], 'Barthels'));
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
