<?php
namespace App\Model\Table;

use App\Model\Entity\Culture;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cultures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsToMany $ListAntibiotics
 */
class CulturesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('cultures');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsToMany('ListAntibiotics', [
            'foreignKey' => 'culture_id',
            'targetForeignKey' => 'list_antibiotic_id',
            'joinTable' => 'list_antibiotics_cultures'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('data_coleta');

        $validator
            ->allowEmpty('data_liberacao_resultado');

        $validator
            ->boolean('em_uso_de_atb')
            ->allowEmpty('em_uso_de_atb');

        $validator
            ->allowEmpty('resultado');

        $validator
            ->allowEmpty('amostra_de_material');

        $validator
            ->allowEmpty('germe');

        $validator
            ->boolean('germe_tem_resistencia')
            ->allowEmpty('germe_tem_resistencia');

        $validator
            ->allowEmpty('antibioticos_resistentes');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
