<?php
namespace App\Model\Table;

use App\Model\Entity\SapsIiiScore;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SapsIiiScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SapsIiiScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('saps_iii_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        // ->date('data_de_realizacao')
        ->requirePresence('data_de_realizacao', 'create')
            ->notEmpty('data_de_realizacao');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            ->allowEmpty('tempo_de_estadia_antes_a_adimissao_na_uti');

        $validator
            ->allowEmpty('origem_intra_hospitalar_antes_da_admissao_na_uti');

        $validator
            ->boolean('terapia_de_cancer')
            ->allowEmpty('terapia_de_cancer');

        $validator
            ->boolean('cancer')
            ->allowEmpty('cancer');

        $validator
            ->boolean('haematological_cancer')
            ->allowEmpty('haematological_cancer');

        $validator
            ->boolean('chron')
            ->allowEmpty('chron');

        $validator
            ->boolean('cirrose')
            ->allowEmpty('cirrose');

        $validator
            ->boolean('aids')
            ->allowEmpty('aids');

        $validator
            ->boolean('uso_das_principais_opcoes_terapeuticas')
            ->allowEmpty('uso_das_principais_opcoes_terapeuticas');

        $validator
            ->boolean('admissao_na_uti_foi_planejada')
            ->allowEmpty('admissao_na_uti_foi_planejada');

        $validator
            ->allowEmpty('motivo_para_a_admissao_na_uti');

        $validator
            ->allowEmpty('status_cirurgica_na_admissao_da_uti');

        $validator
            ->allowEmpty('localizacao_anatomica_da_cirurgia');

        $validator
            ->allowEmpty('infeccao_aguda_na_admissao_da_uti');

        $validator
            ->allowEmpty('gcs_estimado_menor');

        $validator
            ->allowEmpty('total_de_bilirubine');

        $validator
            ->allowEmpty('temperatura_corporal');

        $validator
            ->allowEmpty('creatina');

        $validator
            ->allowEmpty('frequencia_cardiaca_mais_alta');

        $validator
            ->allowEmpty('leucocitos_menor');

        $validator
            ->allowEmpty('concentracao_de_ion_hidrogenio_menor');

        $validator
            ->allowEmpty('plaquetas_menor');

        $validator
            ->allowEmpty('oxigenacao');

        $validator
            ->allowEmpty('pressao_sanguinea_sistolica');

        $validator
            ->integer('pontuacao')
            ->allowEmpty('pontuacao');

        $validator
            ->integer('probabilidade_de_morte')
            ->allowEmpty('probabilidade_de_morte');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
