<?php
namespace App\Model\Table;

use App\Model\Entity\Unit;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Units Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Groups
 * @property \Cake\ORM\Association\HasMany $AreasOfOccupationProfessionals
 * @property \Cake\ORM\Association\HasMany $HealthInsurancePlans
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $IndicatorsUnits
 * @property \Cake\ORM\Association\HasMany $Origins
 * @property \Cake\ORM\Association\HasMany $Professionals
 * @property \Cake\ORM\Association\HasMany $ProfessionalsSpecialties
 * @property \Cake\ORM\Association\HasMany $Sectors
 * @property \Cake\ORM\Association\HasMany $Signs
 * @property \Cake\ORM\Association\HasMany $SurgicalComplications
 * @property \Cake\ORM\Association\HasMany $TciTypes
 * @property \Cake\ORM\Association\HasMany $Users
 * @property \Cake\ORM\Association\BelongsToMany $Patients
 * @property \Cake\ORM\Association\BelongsToMany $Users
 */
class UnitsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('units');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsTo('Groups', [
            'foreignKey' => 'group_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('AreasOfOccupationProfessionals', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('HealthInsurancePlans', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('IndicatorsUnits', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('Origins', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('Professionals', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('ProfessionalsSpecialties', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('Sectors', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('Signs', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('SurgicalComplications', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('TciTypes', [
            'foreignKey' => 'unit_id'
        ]);
        $this->hasMany('Users', [
            'foreignKey' => 'unit_id'
        ]);
        $this->belongsToMany('Patients', [
            'foreignKey' => 'unit_id',
            'targetForeignKey' => 'patient_id',
            'joinTable' => 'patients_units'
        ]);
        $this->belongsToMany('Users', [
            'foreignKey' => 'unit_id',
            'targetForeignKey' => 'user_id',
            'joinTable' => 'units_users'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->allowEmpty('telephone');

        $validator
            ->allowEmpty('street');

        $validator
            ->allowEmpty('city');

        $validator
            ->allowEmpty('cep');

        $validator
            ->allowEmpty('address_number');

        $validator
            ->allowEmpty('state');

        $validator
            ->allowEmpty('term_condition');

        $validator
            ->boolean('is_active')
            ->requirePresence('is_active', 'create')
            ->notEmpty('is_active');

        $validator
            ->time('tempo_de_descontaminacao_da_sala_cirurgica')
            ->allowEmpty('tempo_de_descontaminacao_da_sala_cirurgica');

        $validator
            ->time('tempo_de_descontaminacao_de_leito_da_UTI')
            ->allowEmpty('tempo_de_descontaminacao_de_leito_da_UTI');

        $validator
            ->time('tempo_de_descontaminacao_da_sala_cirurgica_contaminada')
            ->allowEmpty('tempo_de_descontaminacao_da_sala_cirurgica_contaminada');

        $validator
            ->time('tempo_de_descontaminacao_de_leito_da_unidade_de_internacao')
            ->allowEmpty('tempo_de_descontaminacao_de_leito_da_unidade_de_internacao');

        $validator
            ->allowEmpty('termo_de_consentimento_informado');

        $validator
            ->allowEmpty('modelo_de_boletim_medico_file');

        $validator
            ->allowEmpty('modelo_de_descricao_de_informacao_do_paciente_file');

        $validator
            ->allowEmpty('modelo_de_relatorio_medico_padrao_file');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));
        $rules->add($rules->existsIn(['group_id'], 'Groups'));
        return $rules;
    }
}
