<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Crib Score']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="cribScores index col-md-10 columns content">
    <h3>Crib Scores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('peso_nascimento') ?></th>
                <th><?= $this->Paginator->sort('idade_gestacional') ?></th>
                <th><?= $this->Paginator->sort('malfomacao_congenita') ?></th>
                <th><?= $this->Paginator->sort('be_maximo_nas_primeiros_12h_de_vida') ?></th>
                <th><?= $this->Paginator->sort('fio2_minima_apropriada_nas_primeiras_12h_de_vida') ?></th>
                <th><?= $this->Paginator->sort('fio2_maxima_apropriada_nas_primeiras_12h_de_vida') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($cribScores as $cribScore): ?>
            <tr>
                <td><?= $this->Number->format($cribScore->id) ?></td>
                <td><?= h($cribScore->peso_nascimento) ?></td>
                <td><?= $this->Number->format($cribScore->idade_gestacional) ?></td>
                <td><?= h($cribScore->malfomacao_congenita) ?></td>
                <td><?= h($cribScore->be_maximo_nas_primeiros_12h_de_vida) ?></td>
                <td><?= h($cribScore->fio2_minima_apropriada_nas_primeiras_12h_de_vida) ?></td>
                <td><?= h($cribScore->fio2_maxima_apropriada_nas_primeiras_12h_de_vida) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $cribScore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $cribScore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $cribScore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cribScore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>