<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Opinion Answer']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Opinion Requests']), ['controller' => 'MedicalOpinionRequests', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Opinion Request']), ['controller' => 'MedicalOpinionRequests', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Users']), ['controller' => 'Users', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['User']), ['controller' => 'Users', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="medicalOpinionAnswers index col-md-10 columns content">
    <h3>Medical Opinion Answers</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('answer') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('modified') ?></th>
                <th><?= $this->Paginator->sort('medical_opinion_request_id') ?></th>
                <th><?= $this->Paginator->sort('user_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($medicalOpinionAnswers as $medicalOpinionAnswer): ?>
            <tr>
                <td><?= $this->Number->format($medicalOpinionAnswer->id) ?></td>
                <td><?= h($medicalOpinionAnswer->answer) ?></td>
                <td><?= h($medicalOpinionAnswer->created) ?></td>
                <td><?= h($medicalOpinionAnswer->modified) ?></td>
                <td><?= $medicalOpinionAnswer->has('medical_opinion_request') ? $this->Html->link($medicalOpinionAnswer->medical_opinion_request->id, ['controller' => 'MedicalOpinionRequests', 'action' => 'view', $medicalOpinionAnswer->medical_opinion_request->id]) : '' ?></td>
                <td><?= $medicalOpinionAnswer->has('user') ? $this->Html->link($medicalOpinionAnswer->user->name, ['controller' => 'Users', 'action' => 'view', $medicalOpinionAnswer->user->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?php //echo $this->Html->link(__('View'), ['action' => 'view', $medicalOpinionAnswer->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $medicalOpinionAnswer->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $medicalOpinionAnswer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medicalOpinionAnswer->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>