<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * UnitsUsers Controller
 *
 * @property \App\Model\Table\UnitsUsersTable $UnitsUsers
 */
class UnitsUsersController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Users', 'Units']
        ];
        $unitsUsers = $this->paginate($this->UnitsUsers);

        $this->set(compact('unitsUsers'));
        $this->set('_serialize', ['unitsUsers']);
    }

    /**
     * View method
     *
     * @param string|null $id Units User id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $unitsUser = $this->UnitsUsers->get($id, [
            'contain' => ['Users', 'Units']
        ]);

        $this->set('unitsUser', $unitsUser);
        $this->set('_serialize', ['unitsUser']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $unitsUser = $this->UnitsUsers->newEntity();
        if ($this->request->is('post')) {
            $unitsUser = $this->UnitsUsers->patchEntity($unitsUser, $this->request->data);
            if ($this->UnitsUsers->save($unitsUser)) {
                $this->Flash->success(__('The units user has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The units user could not be saved. Please, try again.'));
            }
        }
        $users = $this->UnitsUsers->Users->find('list', ['limit' => 200]);
        $units = $this->UnitsUsers->Units->find('list', ['limit' => 200]);
        $this->set(compact('unitsUser', 'users', 'units'));
        $this->set('_serialize', ['unitsUser']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Units User id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $unitsUser = $this->UnitsUsers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $unitsUser = $this->UnitsUsers->patchEntity($unitsUser, $this->request->data);
            if ($this->UnitsUsers->save($unitsUser)) {
                $this->Flash->success(__('The units user has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The units user could not be saved. Please, try again.'));
            }
        }
        $users = $this->UnitsUsers->Users->find('list', ['limit' => 200]);
        $units = $this->UnitsUsers->Units->find('list', ['limit' => 200]);
        $this->set(compact('unitsUser', 'users', 'units'));
        $this->set('_serialize', ['unitsUser']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Units User id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $unitsUser = $this->UnitsUsers->get($id);
        if ($this->UnitsUsers->delete($unitsUser)) {
            $this->Flash->success(__('The units user has been deleted.'));
        } else {
            $this->Flash->error(__('The units user could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
