<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * Signs Controller
 *
 * @property \App\Model\Table\SignsTable $Signs
 */
class SignsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Sinalização');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Signs', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($unit_id = 0)
    {
        $this->paginate = [
            'conditions' => ['Signs.unit_id =' => $unit_id],
            'contain'    => ['Units'],
        ];

        $signs = $this->paginate($this->Signs);

        $this->set(compact('signs', 'unit_id'));
        $this->set('_serialize', ['signs']);
    }

    /**
     * View method
     *
     * @param string|null $id Sign id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($sign_id = 0, $unit_id = 0)
    {
        $sign = $this->Signs->get($sign_id, [
            'contain' => ['Units'],
        ]);

        $this->set('unit_id', $unit_id);
        $this->set('sign', $sign);
        $this->set('_serialize', ['sign']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($unit_id = 0)
    {
        $sign    = $this->Signs->newEntity();
        $sign_db = TableRegistry::get('Groups');

        if ($this->request->is('post')) {
            //$sign = $this->Signs->patchEntity($sign, $this->request->data);

            if ($this->Upload->sendSign($this->request->data)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index', $unit_id]);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $units = $this->Signs->Units->find('list', ['limit' => 200]);
        $this->set('unit_id', $unit_id);
        $this->set(compact('sign', 'units', 'sign_db'));
        $this->set('_serialize', ['sign']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Sign id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($sign_id = 0, $unit_id = 0)
    {
        $sign = $this->Signs->get($sign_id, [
            'contain' => [],
        ]);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $sign = $this->Signs->patchEntity($sign, $this->request->data);

            Log::write('debug', '$sign');
            Log::write('debug', $sign);

            //if ($this->Signs->save($sign)) {
            if ($this->Upload->sendSign($sign)) {
                $this->Flash->success(__('A sinalização foi salva com sucesso.'));
                return $this->redirect(['action' => 'index', $unit_id]);
            } else {
                $this->Flash->error(__('A sinalização não pode ser salva. Por favor, tente novamente.'));
            }
        }

        $units = $this->Signs->Units->find('list', ['limit' => 200]);
        $this->set(compact('sign', 'units', 'unit_id'));
        $this->set('_serialize', ['sign']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Sign id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null, $unit_id = 1)
    {
        $this->request->allowMethod(['post', 'delete']);
        $sign = $this->Signs->get($id);

        if ($this->Signs->delete($sign)) {
            $this->Flash->success(__('Foi salvo com sucesso.'));
        } else {
            $this->Flash->error(__('Ocoreu um erro.'));
        }
        //return $this->referer();,
        //"param1" => "val1",
        return $this->redirect(['action' => 'index', $unit_id]);
    }
}
