<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Surgeries Controller
 *
 * @property \App\Model\Table\SurgeriesTable $Surgeries
 */
class SurgeriesController extends AppController
{

    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Internação');

        $session    = $this->request->session();
        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'hospitalizations', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $surgeries = $this->paginate($this->Surgeries);

        $this->set(compact('surgeries'));
        $this->set('_serialize', ['surgeries']);
    }

    /**
     * View method
     *
     * @param string|null $id Surgery id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $surgery = $this->Surgeries->get($id, [
            'contain' => ['Hospitalizations', 'Professionals', 'SurgicalMaterials', 'TypeOfAnesthesias'],
        ]);

        $this->set('surgery', $surgery);
        $this->set('_serialize', ['surgery']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $surgery = $this->Surgeries->newEntity();
        if ($this->request->is('post')) {
            $surgery = $this->Surgeries->patchEntity($surgery, $this->request->data);
            if ($this->Surgeries->save($surgery)) {
                $this->Flash->success(__('The surgery has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgery could not be saved. Please, try again.'));
            }
        }
        $hospitalizations  = $this->Surgeries->Hospitalizations->find('list', ['limit' => 200]);
        $professionals     = $this->Surgeries->Professionals->find('list', ['limit' => 200]);
        $surgicalMaterials = $this->Surgeries->SurgicalMaterials->find('list', ['limit' => 200]);
        $typeOfAnesthesias = $this->Surgeries->TypeOfAnesthesias->find('list', ['limit' => 200]);
        $this->set(compact('surgery', 'hospitalizations', 'professionals', 'surgicalMaterials', 'typeOfAnesthesias'));
        $this->set('_serialize', ['surgery']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Surgery id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $surgery = $this->Surgeries->get($id, [
            'contain' => ['Professionals', 'SurgicalMaterials', 'TypeOfAnesthesias'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $surgery = $this->Surgeries->patchEntity($surgery, $this->request->data);
            if ($this->Surgeries->save($surgery)) {
                $this->Flash->success(__('The surgery has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgery could not be saved. Please, try again.'));
            }
        }
        $hospitalizations  = $this->Surgeries->Hospitalizations->find('list', ['limit' => 200]);
        $professionals     = $this->Surgeries->Professionals->find('list', ['limit' => 200]);
        $surgicalMaterials = $this->Surgeries->SurgicalMaterials->find('list', ['limit' => 200]);
        $typeOfAnesthesias = $this->Surgeries->TypeOfAnesthesias->find('list', ['limit' => 200]);
        $this->set(compact('surgery', 'hospitalizations', 'professionals', 'surgicalMaterials', 'typeOfAnesthesias'));
        $this->set('_serialize', ['surgery']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Surgery id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $surgery = $this->Surgeries->get($id);
        if ($this->Surgeries->delete($surgery)) {
            $this->Flash->success(__('The surgery has been deleted.'));
        } else {
            $this->Flash->error(__('The surgery could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
