<?php
namespace App\Model\Table;

use App\Model\Entity\Hospitalization;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Hospitalizations Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\BelongsTo $Origins
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\HasMany $Bundle
 * @property \Cake\ORM\Association\HasMany $CardiacSurgeryChecklists
 * @property \Cake\ORM\Association\HasMany $DailySafetyChecklists
 * @property \Cake\ORM\Association\HasMany $FugulinAndBraden
 * @property \Cake\ORM\Association\HasMany $HistoricOfLocalizations
 * @property \Cake\ORM\Association\HasMany $Infections
 * @property \Cake\ORM\Association\HasMany $NutritionalAssessments
 * @property \Cake\ORM\Association\HasMany $MedicalBulletins
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionRequests
 * @property \Cake\ORM\Association\HasMany $Prescriptions
 */
class HospitalizationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('hospitalizations');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Patients', [
            'foreignKey' => 'patient_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->belongsTo('Origins', [
            'foreignKey' => 'origin_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType'   => 'INNER',
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('NasScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('ApacheIiScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SnapIiScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('PreDeliricScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SapsIiiScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('CribScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SofaEscores', [
            'foreignKey' => 'hospitalization_id',
        ]);

        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'hospitalization_id',
        ]);

        $this->hasMany('Surgeries', [
            'foreignKey' => 'hospitalization_id',
        ]);

        $this->hasMany('CardiacSurgeryChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('DailySafetyChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('ObstetricSurgeryChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SurgicalChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('FugulinAndBraden', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('HistoricOfLocalizations', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Infections', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('NutritionalAssessments', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('MedicalBulletins', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('MedicalOpinionRequests', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Prescriptions', [
            'foreignKey' => 'hospitalization_id',
        ]);

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType'   => 'INNER',
        ]);

        $this->belongsToMany('Comorbidities', [
            'foreignKey'       => 'hospitalization_id',
            'targetForeignKey' => 'comorbidity_id',
            'joinTable'        => 'comorbidities_hospitalizations',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('health_care_number');

        $validator
            ->notEmpty('type');

        $validator
            ->allowEmpty('complementary_health');

        $validator
        //->date('expected_discharge_day')
        ->notEmpty('expected_discharge_day');

        $validator
            ->boolean('readmission_to_hospital_until_30_days')
            ->allowEmpty('readmission_to_hospital_until_30_days');

        $validator
            ->boolean('rehospitalization_up_24')
            ->allowEmpty('rehospitalization_up_24');

        $validator
            ->numeric('weight')
            ->notEmpty('weight');

        $validator
            ->numeric('height')
            ->notEmpty('height');

        $validator
            ->allowEmpty('systemic_diagnosis');

        $validator
            ->allowEmpty('comorbidities');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['patient_id'], 'Patients'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        $rules->add($rules->existsIn(['origin_id'], 'Origins'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
