<?php
namespace App\Model\Table;

use App\Model\Entity\PreAnestheticVisit;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PreAnestheticVisits Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class PreAnestheticVisitsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pre_anesthetic_visits');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('exame_fisico');

        $validator
            ->allowEmpty('exames_laboratoriais');

        $validator
            ->allowEmpty('observacoes');

        $validator
            ->boolean('tci_cirurgico_preenchido')
            ->allowEmpty('tci_cirurgico_preenchido');

        $validator
            ->boolean('tci_anestesico_ja_preenchido')
            ->allowEmpty('tci_anestesico_ja_preenchido');

        $validator
            ->boolean('motivo_nao_preenchimento_do_tci_anestesico')
            ->allowEmpty('motivo_nao_preenchimento_do_tci_anestesico');

        $validator
            ->allowEmpty('restricoes');

        $validator
            ->boolean('restricoes_pos_operatorio_em_uti')
            ->allowEmpty('restricoes_pos_operatorio_em_uti');

        $validator
            ->allowEmpty('motivo_pos_operatorio_em_uti');

        $validator
            ->allowEmpty('risco_cirurgico');

        $validator
            ->date('data_da_requisicao')
            ->allowEmpty('data_da_requisicao');

        $validator
            ->time('hora_da_requisicao')
            ->allowEmpty('hora_da_requisicao');

        $validator
            ->allowEmpty('via_acesso_da_anestesia');

        $validator
            ->boolean('necessidade_de_monitorizacao_invasiva')
            ->allowEmpty('necessidade_de_monitorizacao_invasiva');

        $validator
            ->allowEmpty('motivo_de_monitorizacao_invasiva');

        $validator
            ->allowEmpty('tipo_anestesia_programada');

        $validator
            ->boolean('via_aerea_dificil')
            ->allowEmpty('via_aerea_dificil');

        $validator
            ->allowEmpty('motivo_via_aerea_dificil');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
