<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Pre Deliric Score']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="preDeliricScores index col-md-10 columns content">
    <h3>Pre Deliric Scores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('grupo_diagnostico') ?></th>
                <th><?= $this->Paginator->sort('hospitalizacao_urgente') ?></th>
                <th><?= $this->Paginator->sort('grupo_de_morfina') ?></th>
                <th><?= $this->Paginator->sort('infeccao') ?></th>
                <th><?= $this->Paginator->sort('coma') ?></th>
                <th><?= $this->Paginator->sort('sedacao') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($preDeliricScores as $preDeliricScore): ?>
            <tr>
                <td><?= $this->Number->format($preDeliricScore->id) ?></td>
                <td><?= h($preDeliricScore->grupo_diagnostico) ?></td>
                <td><?= h($preDeliricScore->hospitalizacao_urgente) ?></td>
                <td><?= h($preDeliricScore->grupo_de_morfina) ?></td>
                <td><?= h($preDeliricScore->infeccao) ?></td>
                <td><?= h($preDeliricScore->coma) ?></td>
                <td><?= h($preDeliricScore->sedacao) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $preDeliricScore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $preDeliricScore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $preDeliricScore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $preDeliricScore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>