<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Event\Event;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 */
class UsersController extends AppController
{
    public $components = array('Auth');

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Usuário');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'users', $action);

        //return parent::isAuthorized($user);
    }

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        $this->Auth->allow(['logout', 'recuperateEmail', 'changePassword', 'getUserByCpf']);
    }

    public function login()
    {
        //$this->layout = 'login';
        $this->viewBuilder()->layout('login');
        $this->set('title', 'Login');

        if ($this->Auth->user()) {
            $session   = $this->request->session();
            $role_name = $session->read('Auth.User.role_name');

            if ($role_name == "Administrador") {
                return $this->redirect($this->Auth->redirectUrl(array('controller' => 'Users', 'action' => 'index')));

            } else {
                return $this->redirect($this->Auth->redirectUrl(array('controller' => 'units', 'action' => 'selectUnit')));

            }
        }

        if ($this->request->is('post')) {
            $user = $this->Auth->identify();

            if ($user && !$user['is_active']) {
                $this->Flash->error(__('Esta conta está suspensa. Por favor, entre em contato com o administrador do sistema.'));

            } else if ($user && $user['is_active']) {
                $roles   = TableRegistry::get('Roles');
                $result  = $roles->findById($user['role_id']);
                $results = $result->toArray();

                $user['role_name'] = $results[0]['name'];

                // Log::write('debug', '$user');
                // Log::write('debug', $user );
                // if ( !$user['is_active'] )
                // {
                //     $this->Flash->error(__('Esta conta está suspensa.'));
                //     return;
                // }

                //return;
                $unitsTable = TableRegistry::get('Units');
                $usersTable = TableRegistry::get('Users');

                //       $query = $unitsTable->find()
                //  ->contain(['Users'])
                // ;

                // $query->innerJoinWith('Users')
                //      ->where(['Users.id' => $user['id'] ])
                //    ;

                $units = $usersTable->get($user['id'], [
                    'contain' => ['Units'],
                ]);

                // $units = $usersTable->find()
                //     ->where(['Users.id =' => $user['id']])
                //     ->contain(['Units'=>['Privileges']])
                //     ->distinct(['Privileges'])
                //     ->toArray();

                // ->innerJoinWith('Privileges')

                //        ->where(['units_users.id' = > $unit_id])
                //    ->autoFields(true);

                $units_ids = [];

                // Log::write('debug', '$units');
                //    Log::write('debug', $units );
                //    echo "<pre>";
                //    print_r($units);
                //    exit;
                // return;
                foreach ($units->units as $key => $value) {
                    // $units_ids[$key] = $value['id'];
                    // Log::write('debug', '$value[privilege_id]');
                    // Log::write('debug', $value);

                    $units_ids[$key] = ['unit_id' => $value['id'], 'privilege' => $value['_joinData']['privilege_id']];
                }
                //return;
                $user['units'] = $units_ids;

                //    $query->toArray();

                //          Log::write('debug', '$units');
                // Log::write('debug', $units);

                $this->Auth->setUser($user);
                // Log::write('debug', '$user');
                // Log::write('debug', $user);
                // Log::write('debug', $user['units']);
                //return;

                switch ($results[0]['name']) {
                    case 'Administrador':
                        return $this->redirect($this->Auth->redirectUrl(array('controller' => 'users', 'action' => 'index')));
                        break;

                    case 'Qualidade':
                        return $this->redirect($this->Auth->redirectUrl(array('controller' => 'units', 'action' => 'selectUnit')));
                        break;

                    case 'Usuário':
                        return $this->redirect($this->Auth->redirectUrl(array('controller' => 'units', 'action' => 'selectUnit')));
                        break;

                    default:
                        return $this->redirect($this->Auth->redirectUrl(array('controller' => 'units', 'action' => 'selectUnit')));
                        break;
                }

                return $this->redirect(['action' => 'index']);

            } else {
                $this->Flash->error(__('Senha ou usuário inválido, tente novamente.'));
            }

        }
    }

    public function logout()
    {
        $this->Flash->success('Você foi deslogado.');
        return $this->redirect($this->Auth->logout());
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($admin = null)
    {
        if ($admin !== null) {
            $this->set('title', 'AdminGH');
        }

        $session = $this->request->session();

        $this->set('authUser', $this->Auth->user());

        $units_id = $session->read('Auth.User.units');

        $unitsTable = TableRegistry::get('Units');

        if ($admin !== null) {
            $query = $this->Users->find()
                ->where(['Users.role_id =' => 1])
                ->contain(['Units'])
            ;
        } else {
            $query = $this->Users->find()
                ->where(['Users.role_id =' => 2])
                ->contain(['Units'])
            ;
        }

        if (isset($units_id)) {

            // $query->innerJoinWith('Units')
            //     ->distinct(['Users.id'])
            //        ->where(['Units.id IN' =>  $units_id])
            //       ;

        }
        // $users = $this->paginate($this->Users);
        $users = $this->paginate($query);

        $this->set(compact('users'));
        $this->set('_serialize', ['users']);
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $session   = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');

        $user = $this->Users->get($id, [
            'contain' => ['Log', 'Roles'],
        ]);

        //      $roles = TableRegistry::get('Roles');
        // $result = $roles->find();
        // $results = $result->toArray();
        // $this->set('roles', $results);

        $this->set('user', $user);
        $this->set('_serialize', ['user']);
    }

    public function recuperateEmail($email = null)
    {
        $this->autoRender = false;
        $users            = TableRegistry::get('Users');

        if ($this->request->is('post')) {

            $email = $this->request->data['email'];
            // $result = $this->Users->find('all', [
            //     ['conditions' => ['email' => $email]],
            // ]);

            $result = $this->Users->find('all', [
                'conditions' => ['email = ' => $email],
            ]);

            $userID = $result->first()['id'];

            // $query = $users->findByEmail($email);
            //$userID = $query->first()['id'];
            Log::write('debug', 'email =' . $email);

            Log::write('debug', 'userID =');
            Log::write('debug', $userID);

            //checa se o usuario existe
            if ($userID) {
                $user = $this->Users->get($userID);

                //gera uma senha
                $password = $this->Users->randomPassword(6);
                //$hasher = new DefaultPasswordHasher();
                //$password_encrypted = $hasher->hash($password);

                $user_obj = array('email' => $user['email'], 'unencrypted_password' => $password, 'name' => $user['name']);

                $user->hiddenProperties(['password' => $password]);

                $user = $this->Users->patchEntity($user, [
                    'password' => $password,
                ]
                );
                if ($this->Users->save($user)) {

                    $user['password'] = $password;
                    $this->Users->sendPassByEmail($user_obj);
                    $this->Flash->success('Sua nova senha foi enviada para o email cadastrado.');

                    $this->redirect(['action' => 'login']);
                } else {
                    $this->Flash->error(__('Ocorreu um erro, tente novamente.'));
                }

            } else {
                $this->Flash->error(__('Não existe nenhuma conta com esse email.'));
            }

        }
        // $this->set('user', $user);
        // $this->set('_serialize', ['user']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($admin = null)
    {
        if ($admin !== null) {
            $this->set('title', 'AdminGH');
        }

        $user = $this->Users->newEntity();

        $roles   = TableRegistry::get('Roles');
        $result  = $roles->find();
        $results = $result->toArray();

        if ($this->request->is('post')) {
            //Log::write('debug', '$this->request->data');
            //Log::write('debug', $this->request->data);
            $user = $this->Users->patchEntity($user, $this->request->data);

            //gera uma senha aleatoria
            $password         = $this->Users->randomPassword(6);
            $user['password'] = $password;
            $user->hiddenProperties(['password' => $password]);
            $user['unencrypted_password'] = $password;

            //$x = $user->errors();

            if ($this->Users->save($user)) {
                //envia a senha por email
                $this->Users->sendPassByEmail($user);

                $this->Flash->success(__('O usuário foi salvo.'));
                return $this->redirect(['action' => 'index']);

            } else {
                $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $this->set(compact('user'));
        $this->set('_serialize', ['user']);
        $this->set('roles', $results);
    }

    public function changePassword()
    {
        $user = $this->Users->get($this->Auth->user('id'));

        if (!empty($this->request->data)) {
            $user = $this->Users->patchEntity($user, [
                'old_password' => $this->request->data['old_password'],
                'password'     => $this->request->data['password1'],
                'password1'    => $this->request->data['password1'],
                'password2'    => $this->request->data['password2'],
            ],
                ['validate' => 'password']
            );
            Log::write('debug', $user);

            if ($this->Users->save($user)) {
                $this->Flash->success('A senha foi salva com sucesso.');
                //$this->redirect('/users/');
            } else {
                $this->Flash->error('Ocorreu um erro, tente novamente.');
            }
        }
        $this->set('user', $user);
        $this->set('_serialize', ['user']);
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        // $user = $this->Users->get($id, [
        //     'contain' => ['Roles', 'Units']
        //     ]);
        //$usersTable = TableRegistry::get('Users');

        $user = $this->Users->find()
            ->where(['Users.id =' => $id])
            ->contain(['Units', 'Roles'])
            ->first()
        ;

        $unitsTable = TableRegistry::get('Units');
        $units      = $unitsTable->find()
            ->contain(['Groups'])
        ;

        $units = $this->paginate($units);
        Log::write('debug', 'units');
        Log::write('debug', $units);

        // $unitsTable = TableRegistry::get('Units');
        // $user = $unitsTable->find();
        // $user->contain(['Users']);

        // $user->leftJoinWith('Users')
        //     ->where(['Users.id =' => $id])
        //      ;

        $can_edit_privilege = false;
        $session            = $this->request->session();
        $role_name          = $session->read('Auth.User.role_name');
        //$can_edit_privilege = $this->Permission->canEditUser($role_name, $user['role']['name']);

        $roles   = TableRegistry::get('Roles');
        $result  = $roles->find();
        $results = $result->toArray();

        if ($this->request->is(['patch', 'post', 'put'])) {
            $user = $this->Users->get($id);
            $user = $this->Users->patchEntity($user, $this->request->data);

            // $user = $this->Users->patchEntity($user,
            //     [
            //                  'old_password'    => $this->request->data['old_password'],
            //                  'password'        => $this->request->data['password1'],
            //                  'password1'     => $this->request->data['password1'],
            //                  'password2'     => $this->request->data['password2']
            //                 ],
            //                        ['validate' => 'password']
            //          );

            //}
            // echo "<pre>";
            // print_r($user);
            // exit;
            if ($this->Users->save($user)) {
                $this->Flash->success(__('As alterações foram salvas.'));

                if ($role_name == "Administrador") {
                    return $this->redirect(['action' => 'index']);

                } elseif ($role_name == "Usuário") {
                    return $this->redirect(['action' => 'listUsersFromUnit']);
                }
            } else {
                $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $this->set('roles', $results);
        $this->set('can_edit_privilege', $can_edit_privilege);
        $this->set(compact('user', 'units'));
        $this->set('_serialize', ['user', 'units']);
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $user              = $this->Users->get($id);
        $user['is_active'] = false;

        if ($this->Users->save($user)) {
            $this->Flash->success(__('O usuário foi desativado.'));
        } else {
            $this->Flash->error(__('O usuário não pode ser desativado. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function desactivate($id = null)
    {
        $this->request->allowMethod(['post', 'desactivate']);
        $session   = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');
        $user      = $this->Users->get($id);

        $user['is_active'] = false;

        if ($this->Users->save($user)) {
            $this->Flash->success(__('O usuario foi suspenso com sucesso.'));
        } else {
            $this->Flash->error(__('O usuario não pode ser suspenso. Por favor, tente novamente.'));
        }

        if ($role_name == "Administrador") {
            return $this->redirect(['action' => 'index']);

        } else if ($role_name == "Usuário") {
            return $this->redirect(['action' => 'listUsersFromUnit']);
        }
    }

    public function activate($id = null)
    {

        $this->request->allowMethod(['post', 'desactivate']);
        $session   = $this->request->session();
        $role_name = $session->read('selected-unit-role-name');

        $user            = $this->Users->get($id);
        $user->is_active = true;

        if ($this->Users->save($user)) {
            $this->Flash->success(__('O usuário foi ativado com sucesso.'));
        } else {
            $this->Flash->error(__('O usuário não pode ser ativado. Por favor, tente novamente.'));
        }

        if ($role_name == "Administrador") {
            return $this->redirect(['action' => 'index']);

        } else if ($role_name == "Usuário") {
            return $this->redirect(['action' => 'listUsersFromUnit']);
        } else {
            return $this->redirect(['action' => 'listUsersFromUnit']);
        }
    }

    public function indexAdmin()
    {
        $session = $this->request->session();

        $this->set('authUser', $this->Auth->user());

        $units_id = $session->read('Auth.User.units');

        $unitsTable = TableRegistry::get('Units');

        $query = $this->Users->find()
            ->where(['Users.role_id =' => 1])
            ->contain(['Units'])
        ;

        $query->innerJoinWith('Units')
            ->distinct(['Users.id'])
            ->where(['Units.id IN' => $units_id])
        ;

        // $users = $this->paginate($this->Users);
        $users = $this->paginate($query);

        $this->set(compact('users'));
        $this->set('_serialize', ['users']);
    }

    public function listUsersFromUnit()
    {
        // if ($admin !== null)
        //     $this->set('title', 'AdminGH');
        //$this->set('authUser', $this->Auth->user());

        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $query   = null;
        $name    = null;
        $cpf     = null;
        $param   = $this->request;

        $unit_role_name = $session->read('selected-unit-role-name');
        $this->set('unit_role_name', $unit_role_name);

        $unitsTable = TableRegistry::get('Units');

        if (isset($param->query['name']) || isset($param->query['cpf'])) {
            $name = $param->query['name'];
            $cpf  = $param->query['cpf'];

            $query = $this->Users->find()
                ->where(['Users.role_id =' => 2, 'Users.cpf LIKE "%' . $cpf . '%"', 'Users.name LIKE "%' . $name . '%"'])
                ->contain(['Units'])
            ;
        } else {

            $query = $this->Users->find()
                ->where(['Users.role_id =' => 2])
                ->contain(['Units'])
            ;
        }

        $query->innerJoinWith('Units')
            ->distinct(['Users.id'])
            ->where(['Units.id =' => $unit_id])
        ;

        // $users = $this->paginate($this->Users);
        $users = $this->paginate($query);

        $this->set(compact('users'));
        $this->set('_serialize', ['users']);
    }

    public function addUserToUnit()
    {
        $professionalsTable = TableRegistry::get('Professionals');
        $types              = TableRegistry::get('Privileges');
        $rolesTable         = TableRegistry::get('Roles');
        $usersTable         = TableRegistry::get('Users');

        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');

        //create entity
        $user         = $this->Users->newEntity();
        $professional = $professionalsTable->newEntity();

        //get roles
        $roles = $rolesTable->find();
        $roles = $roles->toArray();

        //get privileges
        $result  = $types->find();
        $results = $result->toArray();

        if ($this->request->is('post')) {

            //monta a entidade usuário
            $users = $usersTable->newEntity($this->request->data);

            Log::write('debug', 'users');
            Log::write('debug', $users);

            //monta a entidade profissional
            $professionals = $professionalsTable->patchEntity($professional, $this->request->data);

            Log::write('debug', '$professionals');
            Log::write('debug', $professionals);

            //verifica se tem erro
            $z = $user->errors();
            Log::write('debug', '$z');
            Log::write('debug', $z);

            //preenche a entidade usuario
            $user = $this->Users->patchEntity($user, $this->request->data);

            //gera uma senha aleatoria
            $password         = $this->Users->randomPassword(6);
            $user['password'] = $password;
            $user->hiddenProperties(['password' => $password]);
            $user['unencrypted_password'] = $password;

            Log::write('debug', '$user');
            Log::write('debug', $user);

            //verifica se tem erro
            $x = $user->errors();
            Log::write('debug', '$x');
            Log::write('debug', $x);

            //verifica se o usuário ja está cadastrado
            $userExists = $usersTable->exists(['cpf' => $user->cpf]);

            Log::write('debug', '$userExists');
            Log::write('debug', $userExists);

            if (!$userExists) {
                if ($this->Users->save($user)) {
                    Log::write('debug', '$user after save');
                    Log::write('debug', $user);
                    $professionals->user_id = $user->id;
                    //$user->user_id          = $user->id;

                    Log::write('debug', '$professionals before save');
                    Log::write('debug', $professionals);

                    if ($professionalsTable->save($professionals)) {

                        $conn = ConnectionManager::get('default');
                        $stmt = $conn->execute(
                            'INSERT INTO units_users (user_id, unit_id, privilege_id) values (?, ?, ?)',
                            [$user->id, $unit_id, $user->privilege_id]
                        );

                        $this->Users->sendPassByEmail($user);
                        $this->Flash->success(__('O usuário foi salvo.'));
                        return $this->redirect(['action' => 'listUsersFromUnit']);
                    } else {
                        $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
                        $result = $this->Users->delete($user);
                    }

                } else {
                    $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
                }

            } else {
                //usuário já existe
                Log::write('debug', 'Usuário já existe.');
                $userFromDb = $this->Users->find()
                    ->where(['Users.cpf =' => $user->cpf])
                    ->first()
                ;

                //verifica se o usuário já está cadastrado na unidade
                $professionalExists = $professionalsTable->exists(['user_id' => $userFromDb->id, 'unit_id' => $unit_id]);
                if (!$professionalExists) {
                    $professionals->user_id = $userFromDb->id;

                    if ($professionalsTable->save($professionals)) {

                        $conn = ConnectionManager::get('default');
                        $stmt = $conn->execute(
                            'INSERT INTO units_users (user_id, unit_id, privilege_id) values (?, ?, ?)',
                            [$userFromDb->id, $unit_id, $user->privilege_id]
                        );

                        $this->Flash->success(__('O usuário foi salvo.'));
                        return $this->redirect(['action' => 'listUsersFromUnit']);
                    } else {
                        $professionals_error = $professionals->errors();
                        Log::write('debug', $professionals_error);
                        $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
                    }

                } else {
                    $this->Flash->error(__('O usuário já está cadastrado  nessa unidade.'));
                }

            }

        }

        $specialties         = $professionalsTable->Specialties->find('list', ['limit' => 200]);
        $areas_of_occupation = $professionalsTable->AreasOfOccupation->find('list', ['limit' => 200]);
        $areas_of_occupation = $areas_of_occupation->toArray();

        $this->set('unit_id', $unit_id);
        $this->set('roles', $roles);
        $this->set('privileges', $results);
        $this->set(compact('user', 'professional', 'specialties', 'areas_of_occupation'));
        $this->set('_serialize', ['user', 'professional']);
    }

    public function editUserFromUnit($id = null)
    {
        //set privileges to edit
        $can_edit_privilege = false;
        $session            = $this->request->session();
        $role_name          = $session->read('Auth.User.role_name');
        $unit_id            = $session->read('selected-unit');

        $professionalTable = TableRegistry::get('Professionals');

        //get user
        $user = $this->Users->find()
            ->where(['Users.id =' => $id])
        //->contain(['Units', 'Roles'])

            ->contain([
                'Roles',
                'Units',
                'Professionals.Specialties',
                'Professionals' => function ($q) {
                    return $q
                    // ->select(['body', 'author_id'])
                    ->where(['Professionals.unit_id' => $this->request->session()->read('selected-unit')])
                    ;
                },
            ])
        ;

        // $user->innerJoinWith('Professionals')
        //->where(['Professionals.unit_id' => $unit_id])
        //->first()
        //;

        $user = $user->first();
        //$user->professionals = $user->professionals[0];

        //get privileges
        $types   = TableRegistry::get('Privileges');
        $result  = $types->find();
        $results = $result->toArray();
        $this->set('privileges', $results);

        //get units
        $unitsTable = TableRegistry::get('Units');
        $units      = $unitsTable->find()
            ->contain(['Groups'])
        ;

        $units = $this->paginate($units);
        // Log::write('debug', 'units');
        // Log::write('debug', $units);

        //get roles
        $roles   = TableRegistry::get('Roles');
        $result  = $roles->find();
        $results = $result->toArray();

        if ($this->request->is(['patch', 'post', 'put'])) {
            // $user = $this->Users->get($id);
            $user = $this->Users->patchEntity($user, $this->request->data);

            $professional_data = $professionalTable->find()
                ->contain(['Specialties'])
                ->where(['Professionals.user_id =' => $id])
                ->first()
            ;

            $professional = $professionalTable->patchEntity($professional_data, $this->request->data['professionals'][0]);

            // echo "<pre>";
            // print_r($user);
            // exit;

            // Log::write('debug', 'professional');
            // Log::write('debug', $professional);

            // return;
            if ($this->Users->save($user)) {
                $this->Flash->success(__('As alterações foram salvas.'));
                $professionalTable->save($professional);

                if ($role_name == "Administrador") {
                    return $this->redirect(['action' => 'index']);

                } elseif ($role_name == "Usuário") {
                    return $this->redirect(['action' => 'listUsersFromUnit']);
                }
            } else {
                $this->Flash->error(__('O usuário não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $specialties = $professionalTable->Specialties->find('list', ['limit' => 200]);

        $this->set('roles', $results);
        $this->set('can_edit_privilege', $can_edit_privilege);
        $this->set(compact('user', 'units', 'specialties'));
        $this->set('_serialize', ['user', 'units']);
    }

    public function getUserByCpf()
    {
        $this->autoRender = false;

        if ($this->request->is(['post', 'get'])) {
            if (isset($this->request->data['cpf'])) {

                $cpf = $this->request->data['cpf'];

                $userTable = TableRegistry::get('Users');

                $user = $userTable->find()
                    ->where(['Users.cpf =' => $cpf])
                    ->contain(['Units', 'Roles'])
                    ->first()
                ;

                echo json_encode($user, true);

            } else {
                echo "The param was not defined";
                echo "<pre>";
                print_r($this->request);
            }

        } else {
            echo "This action only accepts POST requests.";
        }
    }

}
