<?php
namespace App\Model\Table;

use App\Model\Entity\DiagnosticGroup;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * DiagnosticGroups Model
 *
 * @property \Cake\ORM\Association\HasMany $Cid10
 */
class DiagnosticGroupsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('diagnostic_groups');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->hasMany('Cid10', [
            'foreignKey' => 'diagnostic_group_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }
}
