<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * MedicalCares Controller
 *
 * @property \App\Model\Table\MedicalCaresTable $MedicalCares
 */
class MedicalCaresController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Screenings']
        ];
        $medicalCares = $this->paginate($this->MedicalCares);

        $this->set(compact('medicalCares'));
        $this->set('_serialize', ['medicalCares']);
    }

    /**
     * View method
     *
     * @param string|null $id Medical Care id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $medicalCare = $this->MedicalCares->get($id, [
            'contain' => ['Screenings', 'Diagnostics', 'MedicationReconciliations']
        ]);

        $this->set('medicalCare', $medicalCare);
        $this->set('_serialize', ['medicalCare']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $medicalCare = $this->MedicalCares->newEntity();
        if ($this->request->is('post')) {
            $medicalCare = $this->MedicalCares->patchEntity($medicalCare, $this->request->data);
            if ($this->MedicalCares->save($medicalCare)) {
                $this->Flash->success(__('The medical care has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The medical care could not be saved. Please, try again.'));
            }
        }
        $screenings = $this->MedicalCares->Screenings->find('list', ['limit' => 200]);
        $this->set(compact('medicalCare', 'screenings'));
        $this->set('_serialize', ['medicalCare']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Medical Care id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $medicalCare = $this->MedicalCares->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $medicalCare = $this->MedicalCares->patchEntity($medicalCare, $this->request->data);
            if ($this->MedicalCares->save($medicalCare)) {
                $this->Flash->success(__('The medical care has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The medical care could not be saved. Please, try again.'));
            }
        }
        $screenings = $this->MedicalCares->Screenings->find('list', ['limit' => 200]);
        $this->set(compact('medicalCare', 'screenings'));
        $this->set('_serialize', ['medicalCare']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Medical Care id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $medicalCare = $this->MedicalCares->get($id);
        if ($this->MedicalCares->delete($medicalCare)) {
            $this->Flash->success(__('The medical care has been deleted.'));
        } else {
            $this->Flash->error(__('The medical care could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
