<?php
namespace App\Model\Table;

use App\Model\Entity\IndicatorsSector;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * IndicatorsSectors Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Sectors
 */
class IndicatorsSectorsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('indicators_sectors');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->numeric('taxa_de_ocupacao')
            ->allowEmpty('taxa_de_ocupacao');

        $validator
            ->numeric('indice_de_giro_de_leito')
            ->allowEmpty('indice_de_giro_de_leito');

        $validator
            ->numeric('intervalo_de_substituicao')
            ->allowEmpty('intervalo_de_substituicao');

        $validator
            ->numeric('faixa_de_internacao_menor_que_24h')
            ->allowEmpty('faixa_de_internacao_menor_que_24h');

        $validator
            ->numeric('faixa_de_internacao_ate_7_dias')
            ->allowEmpty('faixa_de_internacao_ate_7_dias');

        $validator
            ->numeric('faixa_de_internacao_ate_21_dias')
            ->allowEmpty('faixa_de_internacao_ate_21_dias');

        $validator
            ->numeric('faixa_de_internacao_superior_28_dias')
            ->allowEmpty('faixa_de_internacao_superior_28_dias');

        $validator
            ->numeric('taxa_de_reinternacao')
            ->allowEmpty('taxa_de_reinternacao');

        $validator
            ->time('tempo_medio_decisao_de_alta_e_alta_efetiva')
            ->allowEmpty('tempo_medio_decisao_de_alta_e_alta_efetiva');

        $validator
            ->time('tempo_medio_permanencia_paciente_em_obito')
            ->allowEmpty('tempo_medio_permanencia_paciente_em_obito');

        $validator
            ->integer('total_de_pacientes_no_mes')
            ->allowEmpty('total_de_pacientes_no_mes');

        $validator
            ->numeric('percentual_de_altas')
            ->allowEmpty('percentual_de_altas');

        $validator
            ->time('tempo_de_permanencia_minimo')
            ->allowEmpty('tempo_de_permanencia_minimo');

        $validator
            ->time('tempo_de_permanencia_medio')
            ->allowEmpty('tempo_de_permanencia_medio');

        $validator
            ->time('tempo_de_permanencia_maximo')
            ->allowEmpty('tempo_de_permanencia_maximo');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['sector_id'], 'Sectors'));
        return $rules;
    }
}
