<?php
namespace App\Model\Table;

use App\Model\Entity\ObstetricSurgeryChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ObstetricSurgeryChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class ObstetricSurgeryChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('obstetric_surgery_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('quais_equipamentos_medicamentos_adicionais_foram_necessarios');

        $validator
            ->boolean('algum_problema_ou_preocupacao_com_o_equipamento')
            ->allowEmpty('algum_problema_ou_preocupacao_com_o_equipamento');

        $validator
            ->allowEmpty('qual_o_nivel_de_urgencia');

        $validator
            ->boolean('paciente_requer_type_and_screen')
            ->allowEmpty('paciente_requer_type_and_screen');

        $validator
            ->boolean('requer_type_and_screen_o_sangue_esta_disponivel')
            ->allowEmpty('requer_type_and_screen_o_sangue_esta_disponivel');

        $validator
            ->boolean('paciente_precisa_de_um_ultrassom')
            ->allowEmpty('paciente_precisa_de_um_ultrassom');

        $validator
            ->boolean('todos_confirmaram_o_nome_e_funcao')
            ->allowEmpty('todos_confirmaram_o_nome_e_funcao');

        $validator
            ->boolean('anestesia_adequada_foi_confirmada')
            ->allowEmpty('anestesia_adequada_foi_confirmada');

        $validator
            ->boolean('urgencia_foi_confirmada')
            ->allowEmpty('urgencia_foi_confirmada');

        $validator
            ->boolean('identidade_consentimento_ e_procedimento_do_paciente_confirmado')
            ->allowEmpty('identidade_consentimento_ e_procedimento_do_paciente_confirmado');

        $validator
            ->boolean('paciente_esteril')
            ->allowEmpty('paciente_esteril');

        $validator
            ->boolean('alguma_preocupacao_com_o_status_do_feto')
            ->allowEmpty('alguma_preocupacao_com_o_status_do_feto');

        $validator
            ->boolean('requerimento_confirmado_com_departamento_pediatrico')
            ->allowEmpty('requerimento_confirmado_com_departamento_pediatrico');

        $validator
            ->boolean('thromboembolism_prophylaxis_necessario')
            ->allowEmpty('thromboembolism_prophylaxis_necessario');

        $validator
            ->boolean('procedimento_nome_alegia_do_paciente_foram_confirmados')
            ->allowEmpty('procedimento_nome_alegia_do_paciente_foram_confirmados');

        $validator
            ->boolean('antibiotico_prophylaxis_foi_usado')
            ->allowEmpty('antibiotico_prophylaxis_foi_usado');

        $validator
            ->boolean('especialista_do_neonatal_esta_presente')
            ->allowEmpty('especialista_do_neonatal_esta_presente');

        $validator
            ->boolean('especialista_neonatal_foi_notificado')
            ->allowEmpty('especialista_neonatal_foi_notificado');

        $validator
            ->boolean('equipe_da_ressurreicao_esta_presente')
            ->allowEmpty('equipe_da_ressurreicao_esta_presente');

        $validator
            ->boolean('equipe_da_ressurreicao_esta_presente_e_operacional')
            ->allowEmpty('equipe_da_ressurreicao_esta_presente_e_operacional');

        $validator
            ->allowEmpty('qual_pontuacao_do_asa');

        $validator
            ->boolean('checklist_de_anestesia_foi_completado')
            ->allowEmpty('checklist_de_anestesia_foi_completado');

        $validator
            ->boolean('paciente_tem_todo_o_monitoramento_necessario')
            ->allowEmpty('paciente_tem_todo_o_monitoramento_necessario');

        $validator
            ->boolean('paciente_tem_alguma_alergia')
            ->allowEmpty('paciente_tem_alguma_alergia');

        $validator
            ->allowEmpty('paciente_tem_qual_alergia');

        $validator
            ->boolean('paciente_apresenta_uma_aspiracao_ruim')
            ->allowEmpty('paciente_apresenta_uma_aspiracao_ruim');

        $validator
            ->boolean('respiracao_ruim_equipamento_assistencia_esta_disponivel')
            ->allowEmpty('respiracao_ruim_equipamento_assistencia_esta_disponivel');

        $validator
            ->boolean('risco_de_hipotermia_operacao_>_1h')
            ->allowEmpty('risco_de_hipotermia_operacao_>_1h');

        $validator
            ->boolean('risco_de_hipotermia_aquecedor_necessario')
            ->allowEmpty('risco_de_hipotermia_aquecedor_necessario');

        $validator
            ->allowEmpty('alguma_preocupacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
