<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * DailyBundles Controller
 *
 * @property \App\Model\Table\DailyBundlesTable $DailyBundles
 */
class DailyBundlesController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Bundle Diário');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'DailyBundles', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Bundles'],
        ];
        $dailyBundles = $this->paginate($this->DailyBundles);

        $this->set(compact('dailyBundles'));
        $this->set('_serialize', ['dailyBundles']);
    }

    /**
     * View method
     *
     * @param string|null $id Daily Bundle id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $dailyBundle = $this->DailyBundles->get($id, [
            'contain' => ['Bundles'],
        ]);

        $this->set('dailyBundle', $dailyBundle);
        $this->set('_serialize', ['dailyBundle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $dailyBundle = $this->DailyBundles->newEntity();
        if ($this->request->is('post')) {
            $dailyBundle = $this->DailyBundles->patchEntity($dailyBundle, $this->request->data);
            if ($this->DailyBundles->save($dailyBundle)) {
                $this->Flash->success(__('The daily bundle has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The daily bundle could not be saved. Please, try again.'));
            }
        }
        $bundles = $this->DailyBundles->Bundles->find('list', ['limit' => 200]);
        $this->set(compact('dailyBundle', 'bundles'));
        $this->set('_serialize', ['dailyBundle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Daily Bundle id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $dailyBundle = $this->DailyBundles->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $dailyBundle = $this->DailyBundles->patchEntity($dailyBundle, $this->request->data);
            if ($this->DailyBundles->save($dailyBundle)) {
                $this->Flash->success(__('The daily bundle has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The daily bundle could not be saved. Please, try again.'));
            }
        }
        $bundles = $this->DailyBundles->Bundles->find('list', ['limit' => 200]);
        $this->set(compact('dailyBundle', 'bundles'));
        $this->set('_serialize', ['dailyBundle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Daily Bundle id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $dailyBundle = $this->DailyBundles->get($id);
        if ($this->DailyBundles->delete($dailyBundle)) {
            $this->Flash->success(__('The daily bundle has been deleted.'));
        } else {
            $this->Flash->error(__('The daily bundle could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
