<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * Hospitalizations Controller
 *
 * @property \App\Model\Table\HospitalizationsTable $Hospitalizations
 */
class HospitalizationsController extends AppController
{
    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Internação');

        $session    = $this->request->session();
        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'hospitalizations', $action);
        //return parent::isAuthorized($user);
    }
    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            //'contain' => ['Patients', 'Screenings', 'Origins', 'Units']
        ];
        $hospitalizations = $this->paginate($this->Hospitalizations);

        $this->set(compact('hospitalizations'));
        $this->set('_serialize', ['hospitalizations']);
    }

    /**
     * View method
     *
     * @param string|null $id Hospitalization id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $hospitalization = $this->Hospitalizations->get($id, [
            //'contain' => ['Patients', 'Screenings', 'Origins', 'Units', 'Bundle', 'CardiacSurgeryChecklists', 'DailySafetyChecklists', 'FugulinAndBraden', 'Infections', 'InitialNutritionalAssessment', 'MedicalBulletins', 'MedicalOpinionRequests', 'Prescriptions']
            'contain' => ['Patients'],
        ]);

        $this->set('hospitalization', $hospitalization);
        $this->set('_serialize', ['hospitalization']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $hospitalization = $this->Hospitalizations->newEntity();

        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');

        $sectorsTable = TableRegistry::get('Sectors');
        $sectors      = $sectorsTable->find()
            ->where(['Sectors.unit_id =' => $unit_id])
            ->toArray()
        ;

        if ($this->request->is('post')) {
            $hospitalization = $this->Hospitalizations->patchEntity($hospitalization, $this->request->data);

            if ($this->Hospitalizations->save($hospitalization)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);

            } else {
                $this->Flash->error(__('The hospitalization could not be saved. Please, try again.'));
            }
        }

        $patients   = $this->Hospitalizations->Patients->find('list', ['limit' => 200]);
        $screenings = $this->Hospitalizations->Screenings->find('list', ['limit' => 200]);
        $origins    = $this->Hospitalizations->Origins->find('list', ['limit' => 200]);
        $units      = $this->Hospitalizations->Units->find('list', ['limit' => 200]);
        $this->set(compact('hospitalization', 'patients', 'screenings', 'origins', 'units', 'sectors'));
        $this->set('_serialize', ['hospitalization']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Hospitalization id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $session = $this->request->session();

        $unit_id      = $session->read('selected-unit');
        $sectorsTable = TableRegistry::get('Sectors');
        $sectors      = $sectorsTable->find()
            ->where(['Sectors.unit_id =' => $unit_id])
            ->toArray()
        ;

        $hospitalization = $this->Hospitalizations->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $hospitalization = $this->Hospitalizations->patchEntity($hospitalization, $this->request->data);
            if ($this->Hospitalizations->save($hospitalization)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The hospitalization could not be saved. Please, try again.'));
            }
        }
        $patients   = $this->Hospitalizations->Patients->find('list', ['limit' => 200]);
        $screenings = $this->Hospitalizations->Screenings->find('list', ['limit' => 200]);
        $origins    = $this->Hospitalizations->Origins->find('list', ['limit' => 200]);
        $units      = $this->Hospitalizations->Units->find('list', ['limit' => 200]);
        $this->set(compact('hospitalization', 'patients', 'screenings', 'origins', 'units', 'sectors'));
        $this->set('_serialize', ['hospitalization']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Hospitalization id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $hospitalization = $this->Hospitalizations->get($id);
        if ($this->Hospitalizations->delete($hospitalization)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('The hospitalization could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    //guarda o id do pacienta na session e redireciona pra pagina de internacao
    public function selectHospitalization($hospitalization_id = null, $action = null, $internation_date = null)
    {
        if ($hospitalization_id !== null && $action !== null) {
            $session = $this->request->session();
            $session->write('selected-hospitalization-date', $internation_date);
            $session->write('selected-hospitalization', $hospitalization_id);

            return $this->redirect(['controller' => 'hospitalizations', 'action' => $action, $hospitalization_id]);
        }
    }
}
