<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Professionals Controller
 *
 * @property \App\Model\Table\ProfessionalsTable $Professionals
 */
class ProfessionalsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
         $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Profissional');
    }

    public function isAuthorized($user)
    {               
       $action = $this->request->params['action'];
        
       return  $this->Permission->hasPermission($user['role_name'], 'professionals', $action);
       //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Users']
        ];
        $professionals = $this->paginate($this->Professionals);

        $this->set(compact('professionals'));
        $this->set('_serialize', ['professionals']);
    }

    /**
     * View method
     *
     * @param string|null $id Professional id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $professional = $this->Professionals->get($id, [
            //'contain' => ['Users', 'Specialties', 'Bundle', 'MedicalOpinionAnswer', 'MedicalOpinionRequests', 'ProfessionalSectors']
        ]);

        $this->set('professional', $professional);
        $this->set('_serialize', ['professional']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $professional = $this->Professionals->newEntity();

        if ($this->request->is('post')) {
            $professional = $this->Professionals->patchEntity($professional, $this->request->data);
            if ($this->Professionals->save($professional)) {
                $this->Flash->success(__('The professional has been saved.'));
                return;
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The professional could not be saved. Please, try again.'));
            }
        }
        
        $users = $this->Professionals->Users->find('list', ['limit' => 200]);
        $specialties = $this->Professionals->Specialties->find('list', ['limit' => 200]);

        $areasOfOccupation = $this->Professionals->areasOfOccupation->find('list', ['limit' => 200]);
        $this->set(compact('professional', 'users', 'specialties', 'areasOfOccupation'));
        $this->set('_serialize', ['professional']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Professional id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $professional = $this->Professionals->get($id, [
            'contain' => ['Specialties']
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $professional = $this->Professionals->patchEntity($professional, $this->request->data);
            if ($this->Professionals->save($professional)) {
                $this->Flash->success(__('The professional has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The professional could not be saved. Please, try again.'));
            }
        }
        $users = $this->Professionals->Users->find('list', ['limit' => 200]);
        $specialties = $this->Professionals->Specialties->find('list', ['limit' => 200]);
        $this->set(compact('professional', 'users', 'specialties'));
        $this->set('_serialize', ['professional']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Professional id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $professional = $this->Professionals->get($id);
        if ($this->Professionals->delete($professional)) {
            $this->Flash->success(__('The professional has been deleted.'));
        } else {
            $this->Flash->error(__('The professional could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
