<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Diagnostic']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Patients']), ['controller' => 'Patients', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Patient']), ['controller' => 'Patients', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Origins']), ['controller' => 'Origins', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Origin']), ['controller' => 'Origins', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Cares']), ['controller' => 'MedicalCares', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Care']), ['controller' => 'MedicalCares', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Comorbidities']), ['controller' => 'Comorbidities', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Comorbidity']), ['controller' => 'Comorbidities', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Other Comorbidities']), ['controller' => 'OtherComorbidities', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Other Comorbidity']), ['controller' => 'OtherComorbidities', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="diagnostics index col-md-10 columns content">
    <h3>Diagnostics</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('origin') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('modified') ?></th>
                <th><?= $this->Paginator->sort('type') ?></th>
                <th><?= $this->Paginator->sort('description') ?></th>
                <th><?= $this->Paginator->sort('is_possible_diagnosis') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($diagnostics as $diagnostic): ?>
            <tr>
                <td><?= $this->Number->format($diagnostic->id) ?></td>
                <td><?= h($diagnostic->origin) ?></td>
                <td><?= h($diagnostic->created) ?></td>
                <td><?= h($diagnostic->modified) ?></td>
                <td><?= h($diagnostic->type) ?></td>
                <td><?= h($diagnostic->description) ?></td>
                <td><?= h($diagnostic->is_possible_diagnosis) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $diagnostic->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $diagnostic->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $diagnostic->id], ['confirm' => __('Are you sure you want to delete # {0}?', $diagnostic->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>