<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Diagnostic']), ['action' => 'edit', $diagnostic->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Diagnostic']), ['action' => 'delete', $diagnostic->id], ['confirm' => __('Are you sure you want to delete # {0}?', $diagnostic->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Diagnostics']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Diagnostic']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Patients']), ['controller' => 'Patients', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Patient']), ['controller' => 'Patients', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Origins']), ['controller' => 'Origins', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Origin']), ['controller' => 'Origins', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Cares']), ['controller' => 'MedicalCares', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Care']), ['controller' => 'MedicalCares', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Comorbidities']), ['controller' => 'Comorbidities', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Comorbidity']), ['controller' => 'Comorbidities', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Other Comorbidities']), ['controller' => 'OtherComorbidities', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Other Comorbidity']), ['controller' => 'OtherComorbidities', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="diagnostics view col-lg-10 col-md-9">
    <h3><?= h($diagnostic->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Origin</th>
            <td><?= h($diagnostic->origin) ?></td>
        </tr>
        <tr>
            <th>Type</th>
            <td><?= h($diagnostic->type) ?></td>
        </tr>
        <tr>
            <th>Description</th>
            <td><?= h($diagnostic->description) ?></td>
        </tr>
        <tr>
            <th>Patient</th>
            <td><?= $diagnostic->has('patient') ? $this->Html->link($diagnostic->patient->id, ['controller' => 'Patients', 'action' => 'view', $diagnostic->patient->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Hospitalization</th>
            <td><?= $diagnostic->has('hospitalization') ? $this->Html->link($diagnostic->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $diagnostic->hospitalization->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Origin</th>
            <td><?= $diagnostic->has('origin') ? $this->Html->link($diagnostic->origin->name, ['controller' => 'Origins', 'action' => 'view', $diagnostic->origin->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Medical Care</th>
            <td><?= $diagnostic->has('medical_care') ? $this->Html->link($diagnostic->medical_care->id, ['controller' => 'MedicalCares', 'action' => 'view', $diagnostic->medical_care->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Emergency Surgery</th>
            <td><?= h($diagnostic->emergency_surgery) ?></td>
        </tr>
        <tr>
            <th>Routine Surgery</th>
            <td><?= h($diagnostic->routine_surgery) ?></td>
        </tr>
        <tr>
            <th>Clinic</th>
            <td><?= h($diagnostic->clinic) ?></td>
        </tr>
        <tr>
            <th>Grave Comorbidities</th>
            <td><?= h($diagnostic->grave_comorbidities) ?></td>
        </tr>
        <tr>
            <th>Other Comorbidities</th>
            <td><?= h($diagnostic->other_comorbidities) ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($diagnostic->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($diagnostic->created) ?></tr>
        </tr>
        <tr>
            <th>Modified</th>
            <td><?= h($diagnostic->modified) ?></tr>
        </tr>
        <tr>
            <th>Diagnostic Date</th>
            <td><?= h($diagnostic->diagnostic_date) ?></tr>
        </tr>
        <tr>
            <th>Is Possible Diagnosis</th>
            <td><?= $diagnostic->is_possible_diagnosis ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Comorbidities']) ?></h4>
        <?php if (!empty($diagnostic->comorbidities)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Name</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($diagnostic->comorbidities as $comorbidities): ?>
            <tr>
                <td><?= h($comorbidities->id) ?></td>
                <td><?= h($comorbidities->name) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Comorbidities', 'action' => 'view', $comorbidities->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Comorbidities', 'action' => 'edit', $comorbidities->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Comorbidities', 'action' => 'delete', $comorbidities->id], ['confirm' => __('Are you sure you want to delete # {0}?', $comorbidities->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Other Comorbidities']) ?></h4>
        <?php if (!empty($diagnostic->other_comorbidities)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Name</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($diagnostic->other_comorbidities as $otherComorbidities): ?>
            <tr>
                <td><?= h($otherComorbidities->id) ?></td>
                <td><?= h($otherComorbidities->name) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'OtherComorbidities', 'action' => 'view', $otherComorbidities->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'OtherComorbidities', 'action' => 'edit', $otherComorbidities->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'OtherComorbidities', 'action' => 'delete', $otherComorbidities->id], ['confirm' => __('Are you sure you want to delete # {0}?', $otherComorbidities->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
