<?php $this->assign('title', $title); ?>

<div class="groups index col-md col-lg columns content">
    <h3>Grupos de Unidade</h3>
    <br>
    <?php
        if ($isLogged['role_name'] == "Administrador")    
        echo '
        <a href="groups/add">
            <button type="button" class="btn btn-primary btn-sm">Novo Grupo de Unidade</button>    
        </a>';
    ?>
    <br><br>    
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('filename', ['label'=>'Logo']) ?></th>                
                <th><?= $this->Paginator->sort('Nome') ?></th>
                <th ><?= $this->Paginator->sort('is_active', array('label'=>'Status')) ?></th>        
                <th class="actions text-right-collum"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($groups as $group): ?>
            <tr>
                <td><?= $this->Html->image('uploads/'.h($group->filename), ['alt' => 'CakePHP', 'width'=>'75px', 'class'=>'img-thumbnail']) ?></td>                  
                <td><?= h($group->name) ?></td>                
                <td> 
                    <?php
                         if ( h($group->is_active) == 1)
                            {echo"Ativo";}
                        else
                            {echo "Suspenso";}
                     ?>
                 </td>

                
                <td class="actions text-right" style="white-space:nowrap">
                    <?php //echo $this->Html->link(__('Ver'), ['action' => 'view', $group->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?php 
                        if ($isLogged['role_name'] == "Administrador")    
                        {
                            echo $this->Html->link(__('Editar'), ['action' => 'edit', $group->id], ['class'=>'btn btn-primary btn-xs']);

                            echo '&nbsp;'. $this->Form->postLink(__('Deletar'), ['action' => 'delete', $group->id], ['confirm' => __('Are you sure you want to delete # {0}?', $group->id), 'class'=>'btn btn-danger btn-xs']) ;
                         }
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
    </div>
    </center>
</div>
