<div class="row">

<div class="hospitalizations index col-md-12 columns content">
    <h3></h3>
    <br>   
    <?php    
        echo $this->Html->link('Internar Paciente',
            ['controller' => 'hospitalizations', 'action' => 'add']
            , array('class' => 'link-bt'));           
    ?>
    <br><br> 
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('created', ['label'=>"Data da Internação"]) ?></th>
                <th><?= $this->Paginator->sort('type', ['label'=>"tipo"]) ?></th>
                <th><?= $this->Paginator->sort('complementary_health',['label'=>"Convênio"]) ?></th>
                <th><?= $this->Paginator->sort('expected_discharge_day', ['label'=>'Data Prevista de Alta']) ?></th>
                <th><?php //echo  $this->Paginator->sort('screening_id') ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if($hospitalizations) : ?>                
            <?php foreach ($hospitalizations as $hospitalization): ?>
            <tr>
                <td><?= h($hospitalization->created) ?></td>                    
                <td><?= h($hospitalization->type) ?></td>
                <td><?= h($hospitalization->complementary_health) ?></td>
                <td><?= h($hospitalization->expected_discharge_day) ?></td>
                <td><?php //echo  $hospitalization->has('screening') ? $this->Html->link($hospitalization->screening->id, ['controller' => 'Screenings', 'action' => 'view', $hospitalization->screening->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('Ver'), ['action' => 'view', $hospitalization->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $hospitalization->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Deletar'), ['action' => 'delete', $hospitalization->id], ['confirm' => __('Are you sure you want to delete # {0}?', $hospitalization->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
            <?php endif; ?>

        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?php if($hospitalizations) : ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?php endif; ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            
        </div>
    </center>
</div>
</div>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= ' <a href="/gh/users/login" class="btn btn-default"><i class="glyphicon glyphicon-home"></i></a>';          
        html+= '<a href="/gh/patients/" class="btn btn-default">Pacientes</a>';   
        html+= '<a href="#" class="breadcumb-active btn btn-default">Internação</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>