<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * CribScores Controller
 *
 * @property \App\Model\Table\CribScoresTable $CribScores
 */
class CribScoresController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CribScores', $action);
        //return parent::isAuthorized($user);
    }
    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $cribScores = $this->paginate($this->CribScores);

        $this->set(compact('cribScores'));
        $this->set('_serialize', ['cribScores']);
    }

    /**
     * View method
     *
     * @param string|null $id Crib Score id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $cribScore = $this->CribScores->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('cribScore', $cribScore);
        $this->set('_serialize', ['cribScore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $cribScore = $this->CribScores->newEntity();
        if ($this->request->is('post')) {
            $cribScore = $this->CribScores->patchEntity($cribScore, $this->request->data);
            if ($this->CribScores->save($cribScore)) {
                $this->Flash->success(__('The crib score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores','action' => 'index']);
            } else {
                $this->Flash->error(__('The crib score could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->CribScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('cribScore', 'hospitalizations'));
        $this->set('_serialize', ['cribScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Crib Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cribScore = $this->CribScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $cribScore = $this->CribScores->patchEntity($cribScore, $this->request->data);
            if ($this->CribScores->save($cribScore)) {
                $this->Flash->success(__('The crib score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores','action' => 'index']);
            } else {
                $this->Flash->error(__('The crib score could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->CribScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('cribScore', 'hospitalizations'));
        $this->set('_serialize', ['cribScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Crib Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cribScore = $this->CribScores->get($id);
        if ($this->CribScores->delete($cribScore)) {
            $this->Flash->success(__('The crib score has been deleted.'));
        } else {
            $this->Flash->error(__('The crib score could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'ApacheIiScores','action' => 'index']);
    }
}
