<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;


/**
 * SnapIiScores Controller
 *
 * @property \App\Model\Table\SnapIiScoresTable $SnapIiScores
 */
class SnapIiScoresController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'SnapIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations']
        ];
        $snapIiScores = $this->paginate($this->SnapIiScores);

        $this->set(compact('snapIiScores'));
        $this->set('_serialize', ['snapIiScores']);
    }

    /**
     * View method
     *
     * @param string|null $id Snap Ii Score id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $snapIiScore = $this->SnapIiScores->get($id, [
            'contain' => ['Hospitalizations']
        ]);

        $this->set('snapIiScore', $snapIiScore);
        $this->set('_serialize', ['snapIiScore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $snapIiScore = $this->SnapIiScores->newEntity();
        if ($this->request->is('post')) {
            $snapIiScore = $this->SnapIiScores->patchEntity($snapIiScore, $this->request->data);
            if ($this->SnapIiScores->save($snapIiScore)) {
                $this->Flash->success(__('The snap ii score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores','action' => 'index']);
            } else {
                  Log::write('debug', $snapIiScore);
             Log::write('debug', $snapIiScore->errors());
                $this->Flash->error(__('The snap ii score could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->SnapIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('snapIiScore', 'hospitalizations'));
        $this->set('_serialize', ['snapIiScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Snap Ii Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $snapIiScore = $this->SnapIiScores->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $snapIiScore = $this->SnapIiScores->patchEntity($snapIiScore, $this->request->data);
            if ($this->SnapIiScores->save($snapIiScore)) {
                $this->Flash->success(__('The snap ii score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores','action' => 'index']);
            } else {
                $this->Flash->error(__('The snap ii score could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->SnapIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('snapIiScore', 'hospitalizations'));
        $this->set('_serialize', ['snapIiScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Snap Ii Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $snapIiScore = $this->SnapIiScores->get($id);
        if ($this->SnapIiScores->delete($snapIiScore)) {
            $this->Flash->success(__('The snap ii score has been deleted.'));
        } else {
            $this->Flash->error(__('The snap ii score could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'ApacheIiScores','action' => 'index']);
    }
}
