<?php
namespace App\Model\Table;

use App\Model\Entity\NutritionalAssessment;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * NutritionalAssessments Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NutritionalAssessmentsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('nutritional_assessments');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('imc_e_menor_do_que_20_5')
            ->allowEmpty('imc_e_menor_do_que_20_5');

        $validator
            ->boolean('paciente_perdeu_peso_nos_ultimos_3_meses')
            ->allowEmpty('paciente_perdeu_peso_nos_ultimos_3_meses');

        $validator
            ->boolean('paciente_teve_sua_ingestao_dietetica')
            ->allowEmpty('paciente_teve_sua_ingestao_dietetica');

        $validator
            ->boolean('paciente_e_gravemente_doente')
            ->allowEmpty('paciente_e_gravemente_doente');

        $validator
            ->boolean('estado_nutricional_normal')
            ->allowEmpty('estado_nutricional_normal');

        $validator
            ->boolean('perda_e_peso_maior_5_em_3_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_3_meses');

        $validator
            ->boolean('perda_e_peso_maior_5_em_2_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_2_meses');

        $validator
            ->boolean('perda_e_peso_maior_5_em_1_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_1_meses');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
