<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * MedicalCare Entity.
 *
 * @property int $id
 * @property string $origin
 * @property string $register_number
 * @property string $allergy
 * @property \Cake\I18n\Time $created
 * @property string $hda
 * @property string $hpp
 * @property string $clinical_examination
 * @property string $pa
 * @property string $fc
 * @property string $spo2
 * @property string $fr
 * @property string $temp
 * @property string $glicemia
 * @property string $laboratory_examination
 * @property string $chest_tomography
 * @property string $tomography
 * @property string $noradrenalina
 * @property string $vasopressina
 * @property string $dobutamina
 * @property string $glasgow
 * @property string $nipride
 * @property string $tridi
 * @property string $ancoron
 * @property string $pcr_previa
 * @property string $midazolam
 * @property string $fentanil
 * @property string $insulina
 * @property string $dexmedetomidina
 * @property string $morfina
 * @property string $reavaluation_need
 * @property string $diagnostic_impression
 * @property string $medical_carescol
 * @property string $conduct
 * @property int $screening_id
 * @property bool $is_active
 * @property \App\Model\Entity\Screening $screening
 * @property \App\Model\Entity\Diagnostic[] $diagnostics
 * @property \App\Model\Entity\MedicationReconciliation[] $medication_reconciliations
 */
class MedicalCare extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
