<?php
namespace App\Model\Table;

use App\Model\Entity\ChestPainProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ChestPainProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class ChestPainProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('chest_pain_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->time('hora_zero')
            ->allowEmpty('hora_zero');

        $validator
            ->time('hora_ecg')
            ->allowEmpty('hora_ecg');

        $validator
            ->allowEmpty('suspeita_sca');

        $validator
            ->time('hora_trombolitico')
            ->allowEmpty('hora_trombolitico');

        $validator
            ->time('aas_hora')
            ->allowEmpty('aas_hora');

        $validator
            ->time('clopidogrel_hora')
            ->allowEmpty('clopidogrel_hora');

        $validator
            ->time('ticagrelor')
            ->allowEmpty('ticagrelor');

        $validator
            ->allowEmpty('tmp_medio_permanencia_uci');

        $validator
            ->allowEmpty('tmp_medio_permanencia_hospitalar');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
