<?php
namespace App\Model\Table;

use App\Model\Entity\Discharge;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Discharges Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class DischargesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('discharges');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('evolucao_intercorrencias_medicacoes_relevantes');

        $validator
            ->requirePresence('condicoes_de_alta_transferencia', 'create')
            ->notEmpty('condicoes_de_alta_transferencia');

        $validator
            ->requirePresence('destino', 'create')
            ->notEmpty('destino');

        $validator
            ->allowEmpty('retornar_ao_consultorio_em_x_dias');

        $validator
            ->allowEmpty('aos_cuidados_de');

        $validator
            ->allowEmpty('observacoes');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
