<?php
namespace App\Model\Table;

use App\Model\Entity\MedicalBulletin;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicalBulletins Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class MedicalBulletinsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medical_bulletins');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('consciencia');

        $validator
            ->allowEmpty('respiracao');

        $validator
            ->allowEmpty('alimentacao');

        $validator
            ->boolean('febra')
            ->allowEmpty('febra');

        $validator
            ->allowEmpty('exames_laboratoriais');

        $validator
            ->allowEmpty('exame_de_imagem');

        $validator
            ->allowEmpty('estado_geral');

        $validator
            ->allowEmpty('previsao_de_alta');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
