<?php
namespace App\Model\Table;

use App\Model\Entity\SuspectedMeProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SuspectedMeProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $SupplementaryExaminations
 */
class SuspectedMeProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('suspected_me_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('SupplementaryExaminations', [
            'foreignKey' => 'suspected_me_protocol_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('causa_do_coma');

        $validator
            ->boolean('uso_de_drogas_depressoras')
            ->allowEmpty('uso_de_drogas_depressoras');

        $validator
            ->boolean('hiportemia')
            ->allowEmpty('hiportemia');

        $validator
            ->allowEmpty('1_exame_data');

        $validator
            ->time('1_exame_hora')
            ->allowEmpty('1_exame_hora');

        $validator
            ->allowEmpty('1_exame_nome_medico');

        $validator
            ->allowEmpty('1_exame_endereco');

        $validator
            ->allowEmpty('1_exame_numero_conselho');

        $validator
            ->boolean('1_exame_coma_aperceptivo')
            ->allowEmpty('1_exame_coma_aperceptivo');

        $validator
            ->boolean('1_exame_ausencia_de_reflexo_corneo')
            ->allowEmpty('1_exame_ausencia_de_reflexo_corneo');

        $validator
            ->boolean('1_exame_ausencia_de_reflexos_oculocefalicos')
            ->allowEmpty('1_exame_ausencia_de_reflexos_oculocefalicos');

        $validator
            ->boolean('1_exame_ausencia_de_respostas_as_provas')
            ->allowEmpty('1_exame_ausencia_de_respostas_as_provas');

        $validator
            ->allowEmpty('2_exame_data');

        $validator
            ->allowEmpty('2_exame_hora');

        $validator
            ->allowEmpty('2_exame_nome_medico');

        $validator
            ->allowEmpty('2_exame_endereco');

        $validator
            ->allowEmpty('2_exame_numero_conselho');

        $validator
            ->allowEmpty('2_exame_coma_aperceptivo');

        $validator
            ->allowEmpty('2_exame_ausencia_de_reflexo_corneo');

        $validator
            ->allowEmpty('2_exame_ausencia_de_reflexos_oculocefalicos');

        $validator
            ->allowEmpty('2_exame_ausencia_de_respostas_as_provas');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
