<?php
namespace App\Model\Table;

use App\Model\Entity\VentilatoryCarePlan;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * VentilatoryCarePlans Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class VentilatoryCarePlansTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('ventilatory_care_plans');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('data');

        $validator
            ->time('hora')
            ->allowEmpty('hora');

        $validator
            ->numeric('ventilador')
            ->allowEmpty('ventilador');

        $validator
            ->numeric('vaa_diametro')
            ->allowEmpty('vaa_diametro');

        $validator
            ->numeric('pcuff_cl')
            ->allowEmpty('pcuff_cl');

        $validator
            ->numeric('modo')
            ->allowEmpty('modo');

        $validator
            ->numeric('vt')
            ->allowEmpty('vt');

        $validator
            ->numeric('volmin')
            ->allowEmpty('volmin');

        $validator
            ->numeric('fr_frt')
            ->allowEmpty('fr_frt');

        $validator
            ->numeric('ti')
            ->allowEmpty('ti');

        $validator
            ->numeric('fluxo')
            ->allowEmpty('fluxo');

        $validator
            ->numeric('i_e')
            ->allowEmpty('i_e');

        $validator
            ->numeric('fio2_m')
            ->allowEmpty('fio2_m');

        $validator
            ->numeric('padm_ppl')
            ->allowEmpty('padm_ppl');

        $validator
            ->numeric('peep_auto_sleep')
            ->allowEmpty('peep_auto_sleep');

        $validator
            ->numeric('raw')
            ->allowEmpty('raw');

        $validator
            ->numeric('cest')
            ->allowEmpty('cest');

        $validator
            ->numeric('cdlin')
            ->allowEmpty('cdlin');

        $validator
            ->numeric('ph')
            ->allowEmpty('ph');

        $validator
            ->numeric('pao2')
            ->allowEmpty('pao2');

        $validator
            ->numeric('paco2')
            ->allowEmpty('paco2');

        $validator
            ->numeric('hco3')
            ->allowEmpty('hco3');

        $validator
            ->numeric('be')
            ->allowEmpty('be');

        $validator
            ->numeric('sato2t')
            ->allowEmpty('sato2t');

        $validator
            ->numeric('gasometria_p_f')
            ->allowEmpty('gasometria_p_f');

        $validator
            ->numeric('fr')
            ->allowEmpty('fr');

        $validator
            ->numeric('vm')
            ->allowEmpty('vm');

        $validator
            ->numeric('irr5')
            ->allowEmpty('irr5');

        $validator
            ->numeric('vc')
            ->allowEmpty('vc');

        $validator
            ->numeric('pimax')
            ->allowEmpty('pimax');

        $validator
            ->numeric('pemax')
            ->allowEmpty('pemax');

        $validator
            ->numeric('etco2')
            ->allowEmpty('etco2');

        $validator
            ->numeric('ventilometria_p_f')
            ->allowEmpty('ventilometria_p_f');

        $validator
            ->numeric('oximetria')
            ->allowEmpty('oximetria');

        $validator
            ->numeric('sedacao_bnm')
            ->allowEmpty('sedacao_bnm');

        $validator
            ->numeric('irrs')
            ->allowEmpty('irrs');

        $validator
            ->numeric('rass')
            ->allowEmpty('rass');

        $validator
            ->numeric('glasgow')
            ->allowEmpty('glasgow');

        $validator
            ->numeric('sct')
            ->allowEmpty('sct');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
