<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Medication']), ['action' => 'edit', $medication->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Medication']), ['action' => 'delete', $medication->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medication->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Medications']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Medication']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Prescriptions']), ['controller' => 'Prescriptions', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Prescription']), ['controller' => 'Prescriptions', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Signs']), ['controller' => 'Signs', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Sign']), ['controller' => 'Signs', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Professionals']), ['controller' => 'Professionals', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Professional']), ['controller' => 'Professionals', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Antibiotics']), ['controller' => 'Antibiotics', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Antibiotic']), ['controller' => 'Antibiotics', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Medications Historic']), ['controller' => 'MedicationsHistoric', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Medications Historic']), ['controller' => 'MedicationsHistoric', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="medications view col-lg-10 col-md-9">
    <h3><?= h($medication->name) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Name</th>
            <td><?= h($medication->name) ?></td>
        </tr>
        <tr>
            <th>Dosage</th>
            <td><?= h($medication->dosage) ?></td>
        </tr>
        <tr>
            <th>Channel</th>
            <td><?= h($medication->channel) ?></td>
        </tr>
        <tr>
            <th>Frequency</th>
            <td><?= h($medication->frequency) ?></td>
        </tr>
        <tr>
            <th>Prescription</th>
            <td><?= $medication->has('prescription') ? $this->Html->link($medication->prescription->id, ['controller' => 'Prescriptions', 'action' => 'view', $medication->prescription->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Sign</th>
            <td><?= $medication->has('sign') ? $this->Html->link($medication->sign->id, ['controller' => 'Signs', 'action' => 'view', $medication->sign->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Professional</th>
            <td><?= $medication->has('professional') ? $this->Html->link($medication->professional->id, ['controller' => 'Professionals', 'action' => 'view', $medication->professional->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($medication->id) ?></td>
        </tr>
        <tr>
            <th>'Sign Id</th>
            <td><?= $this->Number->format($medication->sign_id) ?></td>
        </tr>
        <tr>
            <th>Start Date</th>
            <td><?= h($medication->start_date) ?></tr>
        </tr>
        <tr>
            <th>End Date</th>
            <td><?= h($medication->end_date) ?></tr>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($medication->created) ?></tr>
        </tr>
        <tr>
            <th>Is Antibiotic</th>
            <td><?= $medication->is_antibiotic ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Is Active</th>
            <td><?= $medication->is_active ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Antibiotics']) ?></h4>
        <?php if (!empty($medication->antibiotics)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Culture</th>
                <th>Result</th>
                <th>Rationale For Antibiotic Use</th>
                <th>Medication Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($medication->antibiotics as $antibiotics): ?>
            <tr>
                <td><?= h($antibiotics->id) ?></td>
                <td><?= h($antibiotics->culture) ?></td>
                <td><?= h($antibiotics->result) ?></td>
                <td><?= h($antibiotics->rationale_for_antibiotic_use) ?></td>
                <td><?= h($antibiotics->medication_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Antibiotics', 'action' => 'view', $antibiotics->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Antibiotics', 'action' => 'edit', $antibiotics->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Antibiotics', 'action' => 'delete', $antibiotics->id], ['confirm' => __('Are you sure you want to delete # {0}?', $antibiotics->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Medications Historic']) ?></h4>
        <?php if (!empty($medication->medications_historic)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Name</th>
                <th>Dosage</th>
                <th>Channel</th>
                <th>Frequency</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Created</th>
                <th>Is Antibiotic</th>
                <th>Sign Id</th>
                <th>Medication Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($medication->medications_historic as $medicationsHistoric): ?>
            <tr>
                <td><?= h($medicationsHistoric->id) ?></td>
                <td><?= h($medicationsHistoric->name) ?></td>
                <td><?= h($medicationsHistoric->dosage) ?></td>
                <td><?= h($medicationsHistoric->channel) ?></td>
                <td><?= h($medicationsHistoric->frequency) ?></td>
                <td><?= h($medicationsHistoric->start_date) ?></td>
                <td><?= h($medicationsHistoric->end_date) ?></td>
                <td><?= h($medicationsHistoric->created) ?></td>
                <td><?= h($medicationsHistoric->is_antibiotic) ?></td>
                <td><?= h($medicationsHistoric->sign_id) ?></td>
                <td><?= h($medicationsHistoric->medication_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'MedicationsHistoric', 'action' => 'view', $medicationsHistoric->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'MedicationsHistoric', 'action' => 'edit', $medicationsHistoric->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'MedicationsHistoric', 'action' => 'delete', $medicationsHistoric->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medicationsHistoric->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
