<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Snap Ii Score']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="snapIiScores index col-md-10 columns content">
    <h3>Snap Ii Scores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('pressao_arterial_media_mmhg') ?></th>
                <th><?= $this->Paginator->sort('temperatura') ?></th>
                <th><?= $this->Paginator->sort('pao_fio') ?></th>
                <th><?= $this->Paginator->sort('ph') ?></th>
                <th><?= $this->Paginator->sort('convulsoes_multiplas') ?></th>
                <th><?= $this->Paginator->sort('diurese') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($snapIiScores as $snapIiScore): ?>
            <tr>
                <td><?= $this->Number->format($snapIiScore->id) ?></td>
                <td><?= h($snapIiScore->pressao_arterial_media_mmhg) ?></td>
                <td><?= h($snapIiScore->temperatura) ?></td>
                <td><?= h($snapIiScore->pao_fio) ?></td>
                <td><?= h($snapIiScore->ph) ?></td>
                <td><?= h($snapIiScore->convulsoes_multiplas) ?></td>
                <td><?= h($snapIiScore->diurese) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $snapIiScore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $snapIiScore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $snapIiScore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $snapIiScore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>