<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Indicators Sector']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Sectors']), ['controller' => 'Sectors', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Sector']), ['controller' => 'Sectors', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="indicatorsSectors index col-md-10 columns content">
    <h3>Indicators Sectors</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('taxa_de_ocupacao') ?></th>
                <th><?= $this->Paginator->sort('indice_de_giro_de_leito') ?></th>
                <th><?= $this->Paginator->sort('intervalo_de_substituicao') ?></th>
                <th><?= $this->Paginator->sort('faixa_de_internacao_menor_que_24h') ?></th>
                <th><?= $this->Paginator->sort('faixa_de_internacao_ate_7_dias') ?></th>
                <th><?= $this->Paginator->sort('faixa_de_internacao_ate_21_dias') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($indicatorsSectors as $indicatorsSector): ?>
            <tr>
                <td><?= $this->Number->format($indicatorsSector->id) ?></td>
                <td><?= $this->Number->format($indicatorsSector->taxa_de_ocupacao) ?></td>
                <td><?= $this->Number->format($indicatorsSector->indice_de_giro_de_leito) ?></td>
                <td><?= $this->Number->format($indicatorsSector->intervalo_de_substituicao) ?></td>
                <td><?= $this->Number->format($indicatorsSector->faixa_de_internacao_menor_que_24h) ?></td>
                <td><?= $this->Number->format($indicatorsSector->faixa_de_internacao_ate_7_dias) ?></td>
                <td><?= $this->Number->format($indicatorsSector->faixa_de_internacao_ate_21_dias) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $indicatorsSector->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $indicatorsSector->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $indicatorsSector->id], ['confirm' => __('Are you sure you want to delete # {0}?', $indicatorsSector->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>