<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * SkinIntegrities Controller
 *
 * @property \App\Model\Table\SkinIntegritiesTable $SkinIntegrities
 */
class SkinIntegritiesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Integridade de pele');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        return true;
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => [],
        ];
        $skinIntegrities = $this->paginate($this->SkinIntegrities);

        $this->set(compact('skinIntegrities'));
        $this->set('_serialize', ['skinIntegrities']);
    }

    /**
     * View method
     *
     * @param string|null $id Skin Integrity id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $skinIntegrity = $this->SkinIntegrities->get($id, [
            'contain' => ['FugulinBradenScales'],
        ]);

        $this->set('skinIntegrity', $skinIntegrity);
        $this->set('_serialize', ['skinIntegrity']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $skinIntegrity = $this->SkinIntegrities->newEntity();
        if ($this->request->is('post')) {
            $skinIntegrity = $this->SkinIntegrities->patchEntity($skinIntegrity, $this->request->data);
            if ($this->SkinIntegrities->save($skinIntegrity)) {
                $this->Flash->success(__('The skin integrity has been saved.'));
                return $this->redirect(['controller' => 'FugulinBradenScales', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The skin integrity could not be saved. Please, try again.'));
            }
        }

        $this->set(compact('skinIntegrity'));
        $this->set('_serialize', ['skinIntegrity']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Skin Integrity id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $skinIntegrity = $this->SkinIntegrities->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $skinIntegrity = $this->SkinIntegrities->patchEntity($skinIntegrity, $this->request->data);
            if ($this->SkinIntegrities->save($skinIntegrity)) {
                $this->Flash->success(__('The skin integrity has been saved.'));
                return $this->redirect(['controller' => 'FugulinBradenScales', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The skin integrity could not be saved. Please, try again.'));
            }
        }

        $this->set(compact('skinIntegrity'));
        $this->set('_serialize', ['skinIntegrity']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Skin Integrity id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null, $fugulin = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $skinIntegrity = $this->SkinIntegrities->get($id);
        if ($this->SkinIntegrities->delete($skinIntegrity)) {
            $this->Flash->success(__('O registro foi deletado'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado.'));
        }
        return $this->redirect(['controller' => 'FugulinBradenScales', 'action' => 'edit', $fugulin]);
        return $this->redirect(['action' => 'index']);
    }

    public function desactivate($id = null)
    {
        $this->request->allowMethod(['post', 'desactivate']);
        $skinIntegrity            = $this->SkinIntegrities->get($id);
        $skinIntegrity->is_active = false;

        if ($this->SkinIntegrities->save($skinIntegrity)) {
            $this->Flash->success(__('O registro foi suspenso com sucesso.'));
        } else {
            $this->Flash->error(__('O registro não pode ser suspenso. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'fugulinBradenScales', 'action' => 'index']);
    }

    public function activate($id = null)
    {

        $this->request->allowMethod(['post', 'activate']);

        $skinIntegrity            = $this->SkinIntegrities->get($id);
        $skinIntegrity->is_active = true;

        if ($this->SkinIntegrities->save($skinIntegrity)) {

            $this->Flash->success(__('O registro foi ativado com sucesso.'));
        } else {
            $this->Flash->error(__('O registro não pode ser ativado. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'fugulinBradenScales', 'action' => 'index']);

    }
}
