<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Cardiac Surgery Checklist']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="cardiacSurgeryChecklists index col-md-10 columns content">
    <h3>Cardiac Surgery Checklists</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('as_informacoes_do_paciente_foram_confirmadas') ?></th>
                <th><?= $this->Paginator->sort('o_consentimento_cirurgico_anestesico_foi_assinado') ?></th>
                <th><?= $this->Paginator->sort('visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel') ?></th>
                <th><?= $this->Paginator->sort('o_checklist_da_anestesia_foi_executado') ?></th>
                <th><?= $this->Paginator->sort('a_ficha_anestesica_esta_completa') ?></th>
                <th><?= $this->Paginator->sort('os_recursos_humanos_estao_disponiveis') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($cardiacSurgeryChecklists as $cardiacSurgeryChecklist): ?>
            <tr>
                <td><?= $this->Number->format($cardiacSurgeryChecklist->id) ?></td>
                <td><?= h($cardiacSurgeryChecklist->as_informacoes_do_paciente_foram_confirmadas) ?></td>
                <td><?= h($cardiacSurgeryChecklist->o_consentimento_cirurgico_anestesico_foi_assinado) ?></td>
                <td><?= h($cardiacSurgeryChecklist->visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel) ?></td>
                <td><?= h($cardiacSurgeryChecklist->o_checklist_da_anestesia_foi_executado) ?></td>
                <td><?= h($cardiacSurgeryChecklist->a_ficha_anestesica_esta_completa) ?></td>
                <td><?= h($cardiacSurgeryChecklist->os_recursos_humanos_estao_disponiveis) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $cardiacSurgeryChecklist->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $cardiacSurgeryChecklist->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $cardiacSurgeryChecklist->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cardiacSurgeryChecklist->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>