<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Nas Score']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="nasScores index col-md-10 columns content">
    <h3>Nas Scores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('monitoramento_e_controles') ?></th>
                <th><?= $this->Paginator->sort('investigacoes_laboratoriais') ?></th>
                <th><?= $this->Paginator->sort('medicacao') ?></th>
                <th><?= $this->Paginator->sort('procedimentos_de_higiene') ?></th>
                <th><?= $this->Paginator->sort('cuidados_com_drenos') ?></th>
                <th><?= $this->Paginator->sort('mobilizacao_e_posicionamento') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($nasScores as $nasScore): ?>
            <tr>
                <td><?= $this->Number->format($nasScore->id) ?></td>
                <td><?= h($nasScore->monitoramento_e_controles) ?></td>
                <td><?= h($nasScore->investigacoes_laboratoriais) ?></td>
                <td><?= h($nasScore->medicacao) ?></td>
                <td><?= h($nasScore->procedimentos_de_higiene) ?></td>
                <td><?= h($nasScore->cuidados_com_drenos) ?></td>
                <td><?= h($nasScore->mobilizacao_e_posicionamento) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $nasScore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $nasScore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $nasScore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $nasScore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>