<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * DiagnosticGroups Controller
 *
 * @property \App\Model\Table\DiagnosticGroupsTable $DiagnosticGroups
 */
class DiagnosticGroupsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $diagnosticGroups = $this->paginate($this->DiagnosticGroups);

        $this->set(compact('diagnosticGroups'));
        $this->set('_serialize', ['diagnosticGroups']);
    }

    /**
     * View method
     *
     * @param string|null $id Diagnostic Group id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $diagnosticGroup = $this->DiagnosticGroups->get($id, [
            'contain' => ['Cid10']
        ]);

        $this->set('diagnosticGroup', $diagnosticGroup);
        $this->set('_serialize', ['diagnosticGroup']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $diagnosticGroup = $this->DiagnosticGroups->newEntity();
        if ($this->request->is('post')) {
            $diagnosticGroup = $this->DiagnosticGroups->patchEntity($diagnosticGroup, $this->request->data);
            if ($this->DiagnosticGroups->save($diagnosticGroup)) {
                $this->Flash->success(__('The diagnostic group has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The diagnostic group could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('diagnosticGroup'));
        $this->set('_serialize', ['diagnosticGroup']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Diagnostic Group id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $diagnosticGroup = $this->DiagnosticGroups->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $diagnosticGroup = $this->DiagnosticGroups->patchEntity($diagnosticGroup, $this->request->data);
            if ($this->DiagnosticGroups->save($diagnosticGroup)) {
                $this->Flash->success(__('The diagnostic group has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The diagnostic group could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('diagnosticGroup'));
        $this->set('_serialize', ['diagnosticGroup']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Diagnostic Group id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $diagnosticGroup = $this->DiagnosticGroups->get($id);
        if ($this->DiagnosticGroups->delete($diagnosticGroup)) {
            $this->Flash->success(__('The diagnostic group has been deleted.'));
        } else {
            $this->Flash->error(__('The diagnostic group could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
